/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import com.codahale.metrics.Metric;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.metrics.SparkMetricResults;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.spark.repackaged.com.google.common.annotations.VisibleForTesting;

class SparkBeamMetric
implements Metric {
    private static final String ILLEGAL_CHARACTERS = "[^A-Za-z0-9\\._-]";
    private static final String ILLEGAL_CHARACTERS_AND_PERIOD = "[^A-Za-z0-9_-]";
    private final SparkMetricResults metricResults = new SparkMetricResults();

    SparkBeamMetric() {
    }

    Map<String, ?> renderAll() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MetricQueryResults metricQueryResults = this.metricResults.queryMetrics(MetricsFilter.builder().build());
        for (MetricResult metricResult : metricQueryResults.counters()) {
            metrics.put(this.renderName(metricResult), metricResult.attempted());
        }
        for (MetricResult metricResult : metricQueryResults.distributions()) {
            DistributionResult result = (DistributionResult)metricResult.attempted();
            metrics.put(this.renderName(metricResult) + ".count", result.count());
            metrics.put(this.renderName(metricResult) + ".sum", result.sum());
            metrics.put(this.renderName(metricResult) + ".min", result.min());
            metrics.put(this.renderName(metricResult) + ".max", result.max());
            metrics.put(this.renderName(metricResult) + ".mean", result.mean());
        }
        return metrics;
    }

    @VisibleForTesting
    String renderName(MetricResult<?> metricResult) {
        String renderedStepName = metricResult.step().replaceAll(ILLEGAL_CHARACTERS_AND_PERIOD, "_");
        if (renderedStepName.endsWith("_")) {
            renderedStepName = renderedStepName.substring(0, renderedStepName.length() - 1);
        }
        MetricName metricName = metricResult.name();
        return (renderedStepName + "." + metricName.namespace() + "." + metricName.name()).replaceAll(ILLEGAL_CHARACTERS, "_");
    }
}

