/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.metrics;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.SparkBeamMetric;
import org.apache.beam.sdk.metrics.DistributionData;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricUpdates;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.spark.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.spark.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.spark.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.spark.repackaged.com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkMetricsContainer
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMetricsContainer.class);
    private volatile transient LoadingCache<String, MetricsContainer> metricsContainers;
    private final Map<MetricKey, MetricUpdates.MetricUpdate<Long>> counters = new HashMap<MetricKey, MetricUpdates.MetricUpdate<Long>>();
    private final Map<MetricKey, MetricUpdates.MetricUpdate<DistributionData>> distributions = new HashMap<MetricKey, MetricUpdates.MetricUpdate<DistributionData>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsContainer getContainer(String stepName) {
        if (this.metricsContainers == null) {
            SparkMetricsContainer sparkMetricsContainer = this;
            synchronized (sparkMetricsContainer) {
                if (this.metricsContainers == null) {
                    this.initializeMetricsContainers();
                }
            }
        }
        try {
            return this.metricsContainers.get(stepName);
        }
        catch (ExecutionException e) {
            LOG.error("Error while creating metrics container", (Throwable)e);
            return null;
        }
    }

    static Collection<MetricUpdates.MetricUpdate<Long>> getCounters() {
        return SparkMetricsContainer.getInstance().counters.values();
    }

    static Collection<MetricUpdates.MetricUpdate<DistributionData>> getDistributions() {
        return SparkMetricsContainer.getInstance().distributions.values();
    }

    SparkMetricsContainer update(SparkMetricsContainer other) {
        this.updateCounters(other.counters.values());
        this.updateDistributions(other.distributions.values());
        return this;
    }

    private static SparkMetricsContainer getInstance() {
        return (SparkMetricsContainer)MetricsAccumulator.getInstance().value();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.materialize();
        out.defaultWriteObject();
    }

    private void materialize() {
        if (this.metricsContainers != null) {
            for (MetricsContainer container : this.metricsContainers.asMap().values()) {
                MetricUpdates cumulative = container.getCumulative();
                this.updateCounters(cumulative.counterUpdates());
                this.updateDistributions(cumulative.distributionUpdates());
            }
        }
    }

    private void updateCounters(Iterable<MetricUpdates.MetricUpdate<Long>> updates) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key;
            MetricUpdates.MetricUpdate<Long> current = this.counters.get(key = metricUpdate.getKey());
            this.counters.put(key, current != null ? MetricUpdates.MetricUpdate.create((MetricKey)key, (Object)((Long)current.getUpdate() + (Long)metricUpdate.getUpdate())) : metricUpdate);
        }
    }

    private void updateDistributions(Iterable<MetricUpdates.MetricUpdate<DistributionData>> updates) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key;
            MetricUpdates.MetricUpdate<DistributionData> current = this.distributions.get(key = metricUpdate.getKey());
            this.distributions.put(key, current != null ? MetricUpdates.MetricUpdate.create((MetricKey)key, (Object)((DistributionData)current.getUpdate()).combine((DistributionData)metricUpdate.getUpdate())) : metricUpdate);
        }
    }

    private void initializeMetricsContainers() {
        this.metricsContainers = CacheBuilder.newBuilder().build(new MetricsContainerCacheLoader());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> metric : new SparkBeamMetric().renderAll().entrySet()) {
            sb.append(metric.getKey()).append(": ").append(metric.getValue()).append(" ");
        }
        return sb.toString();
    }

    @VisibleForTesting
    public static void clear() {
        try {
            MetricsAccumulator.clear();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class MetricsContainerCacheLoader
    extends CacheLoader<String, MetricsContainer> {
        private MetricsContainerCacheLoader() {
        }

        @Override
        public MetricsContainer load(String stepName) throws Exception {
            return new MetricsContainer(stepName);
        }
    }
}

