/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.spark.aggregators.NamedAggregators;
import org.apache.beam.runners.spark.aggregators.SparkAggregators;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceRDD;
import org.apache.beam.runners.spark.io.hadoop.HadoopIO;
import org.apache.beam.runners.spark.io.hadoop.ShardNameBuilder;
import org.apache.beam.runners.spark.io.hadoop.TemplatedAvroKeyOutputFormat;
import org.apache.beam.runners.spark.io.hadoop.TemplatedTextOutputFormat;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.SparkMetricsContainer;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.DoFnFunction;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.MultiDoFnFunction;
import org.apache.beam.runners.spark.translation.SparkAssignWindowFn;
import org.apache.beam.runners.spark.translation.SparkGlobalCombineFn;
import org.apache.beam.runners.spark.translation.SparkGroupAlsoByWindowViaOutputBufferFn;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.SparkRuntimeContext;
import org.apache.beam.runners.spark.translation.StorageLevelPTransform;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.util.Reshuffle;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.spark.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.spark.repackaged.com.google.common.collect.Lists;
import org.apache.beam.spark.repackaged.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TransformTranslator {
    private static final Map<Class<? extends PTransform>, TransformEvaluator<?>> EVALUATORS = Maps.newHashMap();

    private TransformTranslator() {
    }

    private static <T> TransformEvaluator<Flatten.PCollections<T>> flattenPColl() {
        return new TransformEvaluator<Flatten.PCollections<T>>(){

            @Override
            public void evaluate(Flatten.PCollections<T> transform, EvaluationContext context) {
                JavaRDD unionRDD;
                List<TaggedPValue> pcs = context.getInputs((PTransform<?, ?>)transform);
                if (pcs.size() == 0) {
                    unionRDD = context.getSparkContext().emptyRDD();
                } else {
                    JavaRDD[] rdds = new JavaRDD[pcs.size()];
                    for (int i = 0; i < rdds.length; ++i) {
                        Preconditions.checkArgument(pcs.get(i).getValue() instanceof PCollection, "Flatten had non-PCollection value in input: %s of type %s", (Object)pcs.get(i).getValue(), (Object)pcs.get(i).getValue().getClass().getSimpleName());
                        rdds[i] = ((BoundedDataset)context.borrowDataset(pcs.get(i).getValue())).getRDD();
                    }
                    unionRDD = context.getSparkContext().union(rdds);
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(unionRDD));
            }
        };
    }

    private static <K, V, W extends BoundedWindow> TransformEvaluator<GroupByKey<K, V>> groupByKey() {
        return new TransformEvaluator<GroupByKey<K, V>>(){

            @Override
            public void evaluate(GroupByKey<K, V> transform, EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                Accumulator<NamedAggregators> accum = SparkAggregators.getNamedAggregators(context.getSparkContext());
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                Coder keyCoder = coder.getKeyCoder();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder.getValueCoder(), (Coder)windowFn.windowCoder());
                JavaRDD groupedByKey = GroupCombineFunctions.groupByKeyOnly(inRDD, keyCoder, wvCoder);
                JavaRDD groupedAlsoByWindow = groupedByKey.flatMap(new SparkGroupAlsoByWindowViaOutputBufferFn(windowingStrategy, new TranslationUtils.InMemoryStateInternalsFactory(), SystemReduceFn.buffering((Coder)coder.getValueCoder()), context.getRuntimeContext(), accum));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(groupedAlsoByWindow));
            }
        };
    }

    private static <K, InputT, OutputT> TransformEvaluator<Combine.GroupedValues<K, InputT, OutputT>> combineGrouped() {
        return new TransformEvaluator<Combine.GroupedValues<K, InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.GroupedValues<K, InputT, OutputT> transform, EvaluationContext context) {
                CombineWithContext.KeyedCombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.PerKeyCombineFn)transform.getFn());
                final SparkKeyedCombineFn sparkCombineFn = new SparkKeyedCombineFn(combineFn, context.getRuntimeContext(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), ((PCollection)context.getInput(transform)).getWindowingStrategy());
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaRDD outRDD = inRDD.map(new Function<WindowedValue<KV<K, Iterable<InputT>>>, WindowedValue<KV<K, OutputT>>>(){

                    public WindowedValue<KV<K, OutputT>> call(WindowedValue<KV<K, Iterable<InputT>>> in) throws Exception {
                        return WindowedValue.of((Object)KV.of((Object)((KV)in.getValue()).getKey(), sparkCombineFn.apply(in)), (Instant)in.getTimestamp(), (Collection)in.getWindows(), (PaneInfo)in.getPane());
                    }
                });
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRDD));
            }
        };
    }

    private static <InputT, AccumT, OutputT> TransformEvaluator<Combine.Globally<InputT, OutputT>> combineGlobally() {
        return new TransformEvaluator<Combine.Globally<InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.Globally<InputT, OutputT> transform, EvaluationContext context) {
                JavaRDD outRdd;
                Coder aCoder;
                PCollection input = (PCollection)context.getInput(transform);
                Coder iCoder = ((PCollection)context.getInput(transform)).getCoder();
                Coder oCoder = ((PCollection)context.getOutput(transform)).getCoder();
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                WindowedValue.FullWindowedValueCoder wvoCoder = WindowedValue.FullWindowedValueCoder.of((Coder)oCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
                SparkRuntimeContext runtimeContext = context.getRuntimeContext();
                boolean hasDefault = transform.isInsertDefault();
                SparkGlobalCombineFn sparkCombineFn = new SparkGlobalCombineFn(combineFn, runtimeContext, TranslationUtils.getSideInputs(transform.getSideInputs(), context), windowingStrategy);
                try {
                    aCoder = combineFn.getAccumulatorCoder(runtimeContext.getCoderRegistry(), iCoder);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                if (inRdd.isEmpty()) {
                    JavaSparkContext jsc = new JavaSparkContext(inRdd.context());
                    if (hasDefault) {
                        Object defaultValue = combineFn.defaultValue();
                        outRdd = jsc.parallelize(Lists.newArrayList(new byte[][]{CoderHelpers.toByteArray(defaultValue, oCoder)})).map(CoderHelpers.fromByteFunction(oCoder)).map(WindowingHelpers.windowFunction());
                    } else {
                        outRdd = jsc.emptyRDD();
                    }
                } else {
                    Iterable accumulated = GroupCombineFunctions.combineGlobally(inRdd, sparkCombineFn, iCoder, aCoder, windowingStrategy);
                    Iterable output = sparkCombineFn.extractOutput(accumulated);
                    outRdd = context.getSparkContext().parallelize(CoderHelpers.toByteArrays(output, wvoCoder)).map(CoderHelpers.fromByteFunction(wvoCoder));
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }
        };
    }

    private static <K, InputT, AccumT, OutputT> TransformEvaluator<Combine.PerKey<K, InputT, OutputT>> combinePerKey() {
        return new TransformEvaluator<Combine.PerKey<K, InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.PerKey<K, InputT, OutputT> transform, EvaluationContext context) {
                Coder vaCoder;
                PCollection input = (PCollection)context.getInput(transform);
                KvCoder inputCoder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                CombineWithContext.KeyedCombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.PerKeyCombineFn)transform.getFn());
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                SparkRuntimeContext runtimeContext = context.getRuntimeContext();
                Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs(), context);
                final SparkKeyedCombineFn sparkCombineFn = new SparkKeyedCombineFn(combineFn, runtimeContext, sideInputs, windowingStrategy);
                try {
                    vaCoder = combineFn.getAccumulatorCoder(runtimeContext.getCoderRegistry(), inputCoder.getKeyCoder(), inputCoder.getValueCoder());
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaPairRDD accumulatePerKey = GroupCombineFunctions.combinePerKey(inRdd, sparkCombineFn, inputCoder.getKeyCoder(), inputCoder.getValueCoder(), vaCoder, windowingStrategy);
                JavaRDD outRdd = accumulatePerKey.flatMapValues(new Function<Iterable<WindowedValue<KV<K, AccumT>>>, Iterable<WindowedValue<OutputT>>>(){

                    public Iterable<WindowedValue<OutputT>> call(Iterable<WindowedValue<KV<K, AccumT>>> iter) throws Exception {
                        return sparkCombineFn.extractOutput(iter);
                    }
                }).map(TranslationUtils.fromPairFunction()).map(TranslationUtils.toKVByWindowInValue());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }
        };
    }

    private static <InputT, OutputT> TransformEvaluator<ParDo.Bound<InputT, OutputT>> parDo() {
        return new TransformEvaluator<ParDo.Bound<InputT, OutputT>>(){

            @Override
            public void evaluate(ParDo.Bound<InputT, OutputT> transform, EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                DoFn doFn = transform.getFn();
                TranslationUtils.rejectSplittable(doFn);
                TranslationUtils.rejectStateAndTimers(doFn);
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                JavaSparkContext jsc = context.getSparkContext();
                Accumulator<NamedAggregators> aggAccum = SparkAggregators.getNamedAggregators(jsc);
                Accumulator<SparkMetricsContainer> metricsAccum = MetricsAccumulator.getInstance();
                Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs(), context);
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD.mapPartitions(new DoFnFunction(aggAccum, metricsAccum, stepName, doFn, context.getRuntimeContext(), sideInputs, windowingStrategy))));
            }
        };
    }

    private static <InputT, OutputT> TransformEvaluator<ParDo.BoundMulti<InputT, OutputT>> multiDo() {
        return new TransformEvaluator<ParDo.BoundMulti<InputT, OutputT>>(){

            @Override
            public void evaluate(ParDo.BoundMulti<InputT, OutputT> transform, EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                DoFn doFn = transform.getFn();
                TranslationUtils.rejectSplittable(doFn);
                TranslationUtils.rejectStateAndTimers(doFn);
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                JavaSparkContext jsc = context.getSparkContext();
                Accumulator<NamedAggregators> aggAccum = SparkAggregators.getNamedAggregators(jsc);
                Accumulator<SparkMetricsContainer> metricsAccum = MetricsAccumulator.getInstance();
                JavaPairRDD all = inRDD.mapPartitionsToPair(new MultiDoFnFunction(aggAccum, metricsAccum, stepName, doFn, context.getRuntimeContext(), transform.getMainOutputTag(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), windowingStrategy)).cache();
                List<TaggedPValue> pct = context.getOutputs((PTransform<?, ?>)transform);
                for (TaggedPValue e : pct) {
                    JavaPairRDD filtered = all.filter(new TranslationUtils.TupleTagFilter(e.getTag()));
                    JavaRDD values = filtered.values();
                    context.putDataset(e.getValue(), new BoundedDataset(values));
                }
            }
        };
    }

    private static <T> TransformEvaluator<TextIO.Read.Bound> readText() {
        return new TransformEvaluator<TextIO.Read.Bound>(){

            @Override
            public void evaluate(TextIO.Read.Bound transform, EvaluationContext context) {
                String pattern = transform.getFilepattern();
                JavaRDD rdd = context.getSparkContext().textFile(pattern).map(WindowingHelpers.windowFunction());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(rdd));
            }
        };
    }

    private static <T> TransformEvaluator<TextIO.Write.Bound> writeText() {
        return new TransformEvaluator<TextIO.Write.Bound>(){

            @Override
            public void evaluate(TextIO.Write.Bound transform, EvaluationContext context) {
                JavaPairRDD last = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD().map(WindowingHelpers.unwindowFunction()).mapToPair(new PairFunction<T, T, Void>(){

                    public Tuple2<T, Void> call(T t) throws Exception {
                        return new Tuple2(t, null);
                    }
                });
                ShardTemplateInformation shardTemplateInfo = new ShardTemplateInformation(transform.getNumShards(), transform.getShardTemplate(), transform.getFilenamePrefix(), transform.getFilenameSuffix());
                TransformTranslator.writeHadoopFile(last, new Configuration(), shardTemplateInfo, Text.class, NullWritable.class, TemplatedTextOutputFormat.class);
            }
        };
    }

    private static <T> TransformEvaluator<AvroIO.Read.Bound<T>> readAvro() {
        return new TransformEvaluator<AvroIO.Read.Bound<T>>(){

            @Override
            public void evaluate(AvroIO.Read.Bound<T> transform, EvaluationContext context) {
                String pattern = transform.getFilepattern();
                JavaSparkContext jsc = context.getSparkContext();
                JavaRDD avroFile = jsc.newAPIHadoopFile(pattern, AvroKeyInputFormat.class, AvroKey.class, NullWritable.class, new Configuration()).keys();
                JavaRDD rdd = avroFile.map(new Function<AvroKey<T>, T>(){

                    public T call(AvroKey<T> key) {
                        return key.datum();
                    }
                }).map(WindowingHelpers.windowFunction());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(rdd));
            }
        };
    }

    private static <T> TransformEvaluator<AvroIO.Write.Bound<T>> writeAvro() {
        return new TransformEvaluator<AvroIO.Write.Bound<T>>(){

            @Override
            public void evaluate(AvroIO.Write.Bound<T> transform, EvaluationContext context) {
                Job job;
                try {
                    job = Job.getInstance();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                AvroJob.setOutputKeySchema((Job)job, (Schema)transform.getSchema());
                JavaPairRDD last = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD().map(WindowingHelpers.unwindowFunction()).mapToPair(new PairFunction<T, AvroKey<T>, NullWritable>(){

                    public Tuple2<AvroKey<T>, NullWritable> call(T t) throws Exception {
                        return new Tuple2((Object)new AvroKey(t), (Object)NullWritable.get());
                    }
                });
                ShardTemplateInformation shardTemplateInfo = new ShardTemplateInformation(transform.getNumShards(), transform.getShardTemplate(), transform.getFilenamePrefix(), transform.getFilenameSuffix());
                TransformTranslator.writeHadoopFile(last, job.getConfiguration(), shardTemplateInfo, AvroKey.class, NullWritable.class, TemplatedAvroKeyOutputFormat.class);
            }
        };
    }

    private static <T> TransformEvaluator<Read.Bounded<T>> readBounded() {
        return new TransformEvaluator<Read.Bounded<T>>(){

            @Override
            public void evaluate(Read.Bounded<T> transform, EvaluationContext context) {
                JavaSparkContext jsc = context.getSparkContext();
                SparkRuntimeContext runtimeContext = context.getRuntimeContext();
                JavaRDD input = new SourceRDD.Bounded(jsc.sc(), transform.getSource(), runtimeContext).toJavaRDD();
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(input.cache()));
            }
        };
    }

    private static <K, V> TransformEvaluator<HadoopIO.Read.Bound<K, V>> readHadoop() {
        return new TransformEvaluator<HadoopIO.Read.Bound<K, V>>(){

            @Override
            public void evaluate(HadoopIO.Read.Bound<K, V> transform, EvaluationContext context) {
                String pattern = transform.getFilepattern();
                JavaSparkContext jsc = context.getSparkContext();
                JavaPairRDD file = jsc.newAPIHadoopFile(pattern, transform.getFormatClass(), transform.getKeyClass(), transform.getValueClass(), new Configuration());
                JavaRDD rdd = file.map(new Function<Tuple2<K, V>, KV<K, V>>(){

                    public KV<K, V> call(Tuple2<K, V> t2) throws Exception {
                        return KV.of((Object)t2._1(), (Object)t2._2());
                    }
                }).map(WindowingHelpers.windowFunction());
                context.putDataset(transform, new BoundedDataset(rdd));
            }
        };
    }

    private static <K, V> TransformEvaluator<HadoopIO.Write.Bound<K, V>> writeHadoop() {
        return new TransformEvaluator<HadoopIO.Write.Bound<K, V>>(){

            @Override
            public void evaluate(HadoopIO.Write.Bound<K, V> transform, EvaluationContext context) {
                JavaPairRDD last = ((BoundedDataset)context.borrowDataset(transform)).getRDD().map(WindowingHelpers.unwindowFunction()).mapToPair(new PairFunction<KV<K, V>, K, V>(){

                    public Tuple2<K, V> call(KV<K, V> t) throws Exception {
                        return new Tuple2(t.getKey(), t.getValue());
                    }
                });
                ShardTemplateInformation shardTemplateInfo = new ShardTemplateInformation(transform.getNumShards(), transform.getShardTemplate(), transform.getFilenamePrefix(), transform.getFilenameSuffix());
                Configuration conf = new Configuration();
                for (Map.Entry<String, String> e : transform.getConfigurationProperties().entrySet()) {
                    conf.set(e.getKey(), e.getValue());
                }
                TransformTranslator.writeHadoopFile(last, conf, shardTemplateInfo, transform.getKeyClass(), transform.getValueClass(), transform.getFormatClass());
            }
        };
    }

    private static <K, V> void writeHadoopFile(JavaPairRDD<K, V> rdd, Configuration conf, ShardTemplateInformation shardTemplateInfo, Class<?> keyClass, Class<?> valueClass, Class<? extends FileOutputFormat> formatClass) {
        int numShards = shardTemplateInfo.getNumShards();
        String shardTemplate = shardTemplateInfo.getShardTemplate();
        String filenamePrefix = shardTemplateInfo.getFilenamePrefix();
        String filenameSuffix = shardTemplateInfo.getFilenameSuffix();
        if (numShards != 0) {
            rdd = rdd.repartition(numShards);
        }
        int actualNumShards = rdd.partitions().size();
        String template = ShardNameBuilder.replaceShardCount(shardTemplate, actualNumShards);
        String outputDir = ShardNameBuilder.getOutputDirectory(filenamePrefix, template);
        String filePrefix = ShardNameBuilder.getOutputFilePrefix(filenamePrefix, template);
        String fileTemplate = ShardNameBuilder.getOutputFileTemplate(filenamePrefix, template);
        conf.set("spark.beam.fileoutputformat.prefix", filePrefix);
        conf.set("spark.beam.fileoutputformat.template", fileTemplate);
        conf.set("spark.beam.fileoutputformat.suffix", filenameSuffix);
        rdd.saveAsNewAPIHadoopFile(outputDir, keyClass, valueClass, formatClass, conf);
    }

    private static <T, W extends BoundedWindow> TransformEvaluator<Window.Assign<T>> window() {
        return new TransformEvaluator<Window.Assign<T>>(){

            @Override
            public void evaluate(Window.Assign<T> transform, EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                if (TranslationUtils.skipAssignWindows(transform, context)) {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD));
                } else {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD.map(new SparkAssignWindowFn(transform.getWindowFn()))));
                }
            }
        };
    }

    private static <T> TransformEvaluator<Create.Values<T>> create() {
        return new TransformEvaluator<Create.Values<T>>(){

            @Override
            public void evaluate(Create.Values<T> transform, EvaluationContext context) {
                Iterable elems = transform.getElements();
                Coder coder = ((PCollection)context.getOutput(transform)).getCoder();
                context.putBoundedDatasetFromValues((PTransform<?, ? extends PValue>)transform, elems, coder);
            }
        };
    }

    private static <T> TransformEvaluator<View.AsSingleton<T>> viewAsSingleton() {
        return new TransformEvaluator<View.AsSingleton<T>>(){

            @Override
            public void evaluate(View.AsSingleton<T> transform, EvaluationContext context) {
                Iterable<WindowedValue<?>> iter = context.getWindowedValues((PCollection)context.getInput(transform));
                PCollectionView output = (PCollectionView)context.getOutput(transform);
                Coder coderInternal = output.getCoderInternal();
                Iterable<WindowedValue<?>> iterCast = iter;
                context.putPView(output, iterCast, coderInternal);
            }
        };
    }

    private static <T> TransformEvaluator<View.AsIterable<T>> viewAsIter() {
        return new TransformEvaluator<View.AsIterable<T>>(){

            @Override
            public void evaluate(View.AsIterable<T> transform, EvaluationContext context) {
                Iterable<WindowedValue<?>> iter = context.getWindowedValues((PCollection)context.getInput(transform));
                PCollectionView output = (PCollectionView)context.getOutput(transform);
                Coder coderInternal = output.getCoderInternal();
                Iterable<WindowedValue<?>> iterCast = iter;
                context.putPView(output, iterCast, coderInternal);
            }
        };
    }

    private static <ReadT, WriteT> TransformEvaluator<View.CreatePCollectionView<ReadT, WriteT>> createPCollView() {
        return new TransformEvaluator<View.CreatePCollectionView<ReadT, WriteT>>(){

            @Override
            public void evaluate(View.CreatePCollectionView<ReadT, WriteT> transform, EvaluationContext context) {
                Iterable<WindowedValue<?>> iter = context.getWindowedValues((PCollection)context.getInput(transform));
                PCollectionView output = (PCollectionView)context.getOutput(transform);
                Coder coderInternal = output.getCoderInternal();
                Iterable<WindowedValue<?>> iterCast = iter;
                context.putPView(output, iterCast, coderInternal);
            }
        };
    }

    private static TransformEvaluator<StorageLevelPTransform> storageLevel() {
        return new TransformEvaluator<StorageLevelPTransform>(){

            @Override
            public void evaluate(StorageLevelPTransform transform, EvaluationContext context) {
                JavaRDD rdd = ((BoundedDataset)context.borrowDataset(transform)).getRDD();
                JavaSparkContext javaSparkContext = context.getSparkContext();
                WindowedValue.ValueOnlyWindowedValueCoder windowCoder = WindowedValue.getValueOnlyCoder((Coder)StringUtf8Coder.of());
                JavaRDD output = javaSparkContext.parallelize(CoderHelpers.toByteArrays(Collections.singletonList(rdd.getStorageLevel().description()), StringUtf8Coder.of())).map(CoderHelpers.fromByteFunction(windowCoder));
                context.putDataset(transform, new BoundedDataset(output));
            }
        };
    }

    private static <K, V, W extends BoundedWindow> TransformEvaluator<Reshuffle<K, V>> reshuffle() {
        return new TransformEvaluator<Reshuffle<K, V>>(){

            @Override
            public void evaluate(Reshuffle<K, V> transform, EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                Coder keyCoder = coder.getKeyCoder();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder.getValueCoder(), (Coder)windowFn.windowCoder());
                JavaRDD reshuffled = GroupCombineFunctions.reshuffle(inRDD, keyCoder, wvCoder);
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(reshuffled));
            }
        };
    }

    static {
        EVALUATORS.put(Read.Bounded.class, TransformTranslator.readBounded());
        EVALUATORS.put(HadoopIO.Read.Bound.class, TransformTranslator.readHadoop());
        EVALUATORS.put(HadoopIO.Write.Bound.class, TransformTranslator.writeHadoop());
        EVALUATORS.put(ParDo.Bound.class, TransformTranslator.parDo());
        EVALUATORS.put(ParDo.BoundMulti.class, TransformTranslator.multiDo());
        EVALUATORS.put(GroupByKey.class, TransformTranslator.groupByKey());
        EVALUATORS.put(Combine.GroupedValues.class, TransformTranslator.combineGrouped());
        EVALUATORS.put(Combine.Globally.class, TransformTranslator.combineGlobally());
        EVALUATORS.put(Combine.PerKey.class, TransformTranslator.combinePerKey());
        EVALUATORS.put(Flatten.PCollections.class, TransformTranslator.flattenPColl());
        EVALUATORS.put(Create.Values.class, TransformTranslator.create());
        EVALUATORS.put(View.AsSingleton.class, TransformTranslator.viewAsSingleton());
        EVALUATORS.put(View.AsIterable.class, TransformTranslator.viewAsIter());
        EVALUATORS.put(View.CreatePCollectionView.class, TransformTranslator.createPCollView());
        EVALUATORS.put(Window.Assign.class, TransformTranslator.window());
        EVALUATORS.put(Reshuffle.class, TransformTranslator.reshuffle());
        EVALUATORS.put(StorageLevelPTransform.class, TransformTranslator.storageLevel());
    }

    public static class Translator
    implements SparkPipelineTranslator {
        @Override
        public boolean hasTranslation(Class<? extends PTransform<?, ?>> clazz) {
            return EVALUATORS.containsKey(clazz);
        }

        @Override
        public <TransformT extends PTransform<?, ?>> TransformEvaluator<TransformT> translateBounded(Class<TransformT> clazz) {
            TransformEvaluator transformEvaluator = (TransformEvaluator)EVALUATORS.get(clazz);
            Preconditions.checkState(transformEvaluator != null, "No TransformEvaluator registered for BOUNDED transform %s", clazz);
            return transformEvaluator;
        }

        @Override
        public <TransformT extends PTransform<?, ?>> TransformEvaluator<TransformT> translateUnbounded(Class<TransformT> clazz) {
            throw new IllegalStateException("TransformTranslator used in a batch pipeline only supports BOUNDED transforms.");
        }
    }

    private static final class ShardTemplateInformation {
        private final int numShards;
        private final String shardTemplate;
        private final String filenamePrefix;
        private final String filenameSuffix;

        private ShardTemplateInformation(int numShards, String shardTemplate, String filenamePrefix, String filenameSuffix) {
            this.numShards = numShards;
            this.shardTemplate = shardTemplate;
            this.filenamePrefix = filenamePrefix;
            this.filenameSuffix = filenameSuffix;
        }

        int getNumShards() {
            return this.numShards;
        }

        String getShardTemplate() {
            return this.shardTemplate;
        }

        String getFilenamePrefix() {
            return this.filenamePrefix;
        }

        String getFilenameSuffix() {
            return this.filenameSuffix;
        }
    }
}

