/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedDataset<T>
implements Dataset {
    private static final Logger LOG = LoggerFactory.getLogger(UnboundedDataset.class);
    private final JavaDStream<WindowedValue<T>> dStream;
    private final List<Integer> streamSources = new ArrayList<Integer>();

    public UnboundedDataset(JavaDStream<WindowedValue<T>> dStream, List<Integer> streamSources) {
        this.dStream = dStream;
        this.streamSources.addAll(streamSources);
    }

    JavaDStream<WindowedValue<T>> getDStream() {
        return this.dStream;
    }

    List<Integer> getStreamSources() {
        return this.streamSources;
    }

    public void cache() {
        this.dStream.cache();
    }

    @Override
    public void cache(String storageLevel) {
        LOG.warn("Provided StorageLevel ignored for stream, using default level");
        this.cache();
    }

    @Override
    public void action() {
        this.dStream.foreachRDD(new VoidFunction<JavaRDD<WindowedValue<T>>>(){

            public void call(JavaRDD<WindowedValue<T>> rdd) throws Exception {
                rdd.foreach(TranslationUtils.emptyVoidFunction());
            }
        });
    }

    @Override
    public void setName(String name) {
    }
}

