/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SideInputReader;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.spark.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.spark.repackaged.com.google.common.base.Predicate;
import org.apache.beam.spark.repackaged.com.google.common.collect.Iterables;

public class SparkSideInputReader
implements SideInputReader {
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs;

    public SparkSideInputReader(Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, "The PCollectionView passed to sideInput cannot be null ");
        KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>> windowedBroadcastHelper = this.sideInputs.get(view.getTagInternal());
        Preconditions.checkNotNull(windowedBroadcastHelper, "SideInput for view " + view + " is not available.");
        WindowingStrategy sideInputWindowStrategy = (WindowingStrategy)windowedBroadcastHelper.getKey();
        final BoundedWindow sideInputWindow = sideInputWindowStrategy.getWindowFn().getSideInputWindow(window);
        Iterable availableSideInputs = (Iterable)((SideInputBroadcast)windowedBroadcastHelper.getValue()).getValue();
        Iterable sideInputForWindow = Iterables.filter(availableSideInputs, new Predicate<WindowedValue<?>>(){

            @Override
            public boolean apply(@Nullable WindowedValue<?> sideInputCandidate) {
                if (sideInputCandidate == null) {
                    return false;
                }
                for (BoundedWindow sideInputCandidateWindow : sideInputCandidate.getWindows()) {
                    if (!sideInputCandidateWindow.equals(sideInputWindow)) continue;
                    return true;
                }
                return false;
            }
        });
        return (T)view.getViewFn().apply(sideInputForWindow);
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return this.sideInputs != null && this.sideInputs.isEmpty();
    }
}

