/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.SizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SideInputBroadcast<T>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SideInputBroadcast.class);
    private Broadcast<byte[]> bcast;
    private final Coder<T> coder;
    private transient T value;
    private transient byte[] bytes = null;

    private SideInputBroadcast(byte[] bytes, Coder<T> coder) {
        this.bytes = bytes;
        this.coder = coder;
    }

    public static <T> SideInputBroadcast<T> create(byte[] bytes, Coder<T> coder) {
        return new SideInputBroadcast<T>(bytes, coder);
    }

    public synchronized T getValue() {
        if (this.value == null) {
            this.value = this.deserialize();
        }
        return this.value;
    }

    public void broadcast(JavaSparkContext jsc) {
        this.bcast = jsc.broadcast((Object)this.bytes);
    }

    public void unpersist() {
        this.bcast.unpersist();
    }

    private T deserialize() {
        Object val;
        try {
            val = this.coder.decode((InputStream)new ByteArrayInputStream((byte[])this.bcast.value()), new Coder.Context(true));
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage());
            val = null;
        }
        return (T)val;
    }

    public long getBroadcastSizeEstimate() {
        return SizeEstimator.estimate((Object)this.bytes);
    }
}

