/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.spark.SparkNativePipelineVisitor;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineResult;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.TestSparkPipelineOptions;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.TransformTranslator;
import org.apache.beam.runners.spark.translation.streaming.StreamingTransformTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkRunnerDebugger
extends PipelineRunner<SparkPipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRunnerDebugger.class);
    private final SparkPipelineOptions options;

    private SparkRunnerDebugger(SparkPipelineOptions options) {
        this.options = options;
    }

    public static SparkRunnerDebugger fromOptions(PipelineOptions options) {
        if (options instanceof TestSparkPipelineOptions) {
            TestSparkPipelineOptions testSparkPipelineOptions = (TestSparkPipelineOptions)PipelineOptionsValidator.validate(TestSparkPipelineOptions.class, (PipelineOptions)options);
            return new SparkRunnerDebugger(testSparkPipelineOptions);
        }
        SparkPipelineOptions sparkPipelineOptions = (SparkPipelineOptions)PipelineOptionsValidator.validate(SparkPipelineOptions.class, (PipelineOptions)options);
        return new SparkRunnerDebugger(sparkPipelineOptions);
    }

    public SparkPipelineResult run(Pipeline pipeline) {
        SparkNativePipelineVisitor visitor;
        JavaSparkContext jsc = new JavaSparkContext("local[1]", "Debug_Pipeline");
        JavaStreamingContext jssc = new JavaStreamingContext(jsc, new Duration(1000L));
        SparkRunner.initAccumulators(this.options, jsc);
        TransformTranslator.Translator translator = new TransformTranslator.Translator();
        if (this.options.isStreaming() || this.options instanceof TestSparkPipelineOptions && ((TestSparkPipelineOptions)this.options).isForceStreaming()) {
            StreamingTransformTranslator.Translator streamingTranslator = new StreamingTransformTranslator.Translator(translator);
            EvaluationContext ctxt = new EvaluationContext(jsc, pipeline, this.options, jssc);
            visitor = new SparkNativePipelineVisitor(streamingTranslator, ctxt);
        } else {
            EvaluationContext ctxt = new EvaluationContext(jsc, pipeline, this.options, jssc);
            visitor = new SparkNativePipelineVisitor(translator, ctxt);
        }
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        jsc.stop();
        String debugString = visitor.getDebugString();
        LOG.info("Translated Native Spark pipeline:\n" + debugString);
        return new DebugSparkPipelineResult(debugString);
    }

    public static class DebugSparkPipelineResult
    extends SparkPipelineResult {
        private final String debugString;

        DebugSparkPipelineResult(String debugString) {
            super(null, null);
            this.debugString = debugString;
        }

        String getDebugString() {
            return this.debugString;
        }

        @Override
        protected void stop() {
        }

        @Override
        protected PipelineResult.State awaitTermination(org.joda.time.Duration duration) throws TimeoutException, ExecutionException, InterruptedException {
            return PipelineResult.State.DONE;
        }
    }
}

