/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceDStream;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.stateful.StateSpecFunctions;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public class SparkUnboundedSource {
    public static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> UnboundedDataset<T> read(JavaStreamingContext jssc, SerializablePipelineOptions rc, UnboundedSource<T, CheckpointMarkT> source, String stepName) {
        SparkPipelineOptions options = (SparkPipelineOptions)rc.get().as(SparkPipelineOptions.class);
        Long maxRecordsPerBatch = options.getMaxRecordsPerBatch();
        SourceDStream<T, CheckpointMarkT> sourceDStream = new SourceDStream<T, CheckpointMarkT>(jssc.ssc(), source, rc, maxRecordsPerBatch);
        JavaPairInputDStream inputDStream = JavaPairInputDStream$.MODULE$.fromInputDStream(sourceDStream, JavaSparkContext$.MODULE$.fakeClassTag(), JavaSparkContext$.MODULE$.fakeClassTag());
        JavaMapWithStateDStream mapWithStateDStream = inputDStream.mapWithState(StateSpec.function(StateSpecFunctions.mapSourceFunction(rc, stepName)).numPartitions(sourceDStream.getNumPartitions()));
        SparkUnboundedSource.checkpointStream(mapWithStateDStream, options);
        int id = inputDStream.inputDStream().id();
        JavaDStream metadataDStream = mapWithStateDStream.map((Function)new Tuple2MetadataFunction());
        new ReadReportDStream((DStream<Metadata>)metadataDStream.dstream(), id, SparkUnboundedSource.getSourceName(source, id), stepName).register();
        WindowedValue.FullWindowedValueCoder coder = WindowedValue.FullWindowedValueCoder.of((Coder)source.getOutputCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        JavaDStream readUnboundedStream = mapWithStateDStream.flatMap((FlatMapFunction)new Tuple2byteFlatMapFunction()).map(CoderHelpers.fromByteFunction(coder));
        return new UnboundedDataset(readUnboundedStream, Collections.singletonList(id));
    }

    private static <T> String getSourceName(Source<T> source, int id) {
        StringBuilder sb = new StringBuilder();
        for (String s : source.getClass().getSimpleName().replace("$", "").split("(?=[A-Z])")) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            sb.append(trimmed).append(" ");
        }
        return sb.append("[").append(id).append("]").toString();
    }

    private static void checkpointStream(JavaDStream<?> dStream, SparkPipelineOptions options) {
        long checkpointDurationMillis = options.getCheckpointDurationMillis();
        if (checkpointDurationMillis > 0L) {
            dStream.checkpoint(new Duration(checkpointDurationMillis));
        }
    }

    private static class Tuple2byteFlatMapFunction
    implements FlatMapFunction<Tuple2<Iterable<byte[]>, Metadata>, byte[]> {
        private Tuple2byteFlatMapFunction() {
        }

        public Iterator<byte[]> call(Tuple2<Iterable<byte[]>, Metadata> t2) throws Exception {
            return ((Iterable)t2._1()).iterator();
        }
    }

    private static class Tuple2MetadataFunction
    implements Function<Tuple2<Iterable<byte[]>, Metadata>, Metadata> {
        private Tuple2MetadataFunction() {
        }

        public Metadata call(Tuple2<Iterable<byte[]>, Metadata> t2) throws Exception {
            return (Metadata)t2._2();
        }
    }

    public static class Metadata
    implements Serializable {
        private final long numRecords;
        private final Instant lowWatermark;
        private final Instant highWatermark;
        private final long readDurationMillis;
        private final MetricsContainerStepMap metricsContainers;

        public Metadata(long numRecords, Instant lowWatermark, Instant highWatermark, long readDurationMillis, MetricsContainerStepMap metricsContainer) {
            this.numRecords = numRecords;
            this.readDurationMillis = readDurationMillis;
            this.metricsContainers = metricsContainer;
            this.lowWatermark = lowWatermark;
            this.highWatermark = highWatermark;
        }

        long getNumRecords() {
            return this.numRecords;
        }

        Instant getLowWatermark() {
            return this.lowWatermark;
        }

        Instant getHighWatermark() {
            return this.highWatermark;
        }

        public long getReadDurationMillis() {
            return this.readDurationMillis;
        }

        MetricsContainerStepMap getMetricsContainers() {
            return this.metricsContainers;
        }
    }

    private static class ReadReportDStream
    extends DStream<BoxedUnit> {
        private static final String READ_DURATION_MILLIS = "readDurationMillis";
        private static final String NAMESPACE = "spark-runner.io";
        private final DStream<Metadata> parent;
        private final int inputDStreamId;
        private final String sourceName;
        private final String stepName;

        ReadReportDStream(DStream<Metadata> parent, int inputDStreamId, String sourceName, String stepName) {
            super(parent.ssc(), JavaSparkContext$.MODULE$.fakeClassTag());
            this.parent = parent;
            this.inputDStreamId = inputDStreamId;
            this.sourceName = sourceName;
            this.stepName = stepName;
        }

        public Duration slideDuration() {
            return this.parent.slideDuration();
        }

        public List<DStream<?>> dependencies() {
            return JavaConversions.asScalaBuffer(Collections.singletonList(this.parent)).toList();
        }

        public Option<RDD<BoxedUnit>> compute(Time validTime) {
            Option parentRDDOpt = this.parent.getOrCompute(validTime);
            Accumulator<MetricsContainerStepMap> metricsAccum = MetricsAccumulator.getInstance();
            long count = 0L;
            GlobalWatermarkHolder.SparkWatermarks sparkWatermark = null;
            Instant globalLowWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            Instant globalHighWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            long maxReadDuration = 0L;
            if (parentRDDOpt.isDefined()) {
                JavaRDD parentRDD = ((RDD)parentRDDOpt.get()).toJavaRDD();
                for (Metadata metadata : parentRDD.collect()) {
                    count += metadata.getNumRecords();
                    Instant partitionLowWatermark = metadata.getLowWatermark();
                    globalLowWatermarkForBatch = globalLowWatermarkForBatch.isBefore((ReadableInstant)partitionLowWatermark) ? partitionLowWatermark : globalLowWatermarkForBatch;
                    Instant partitionHighWatermark = metadata.getHighWatermark();
                    globalHighWatermarkForBatch = globalHighWatermarkForBatch.isBefore((ReadableInstant)partitionHighWatermark) ? partitionHighWatermark : globalHighWatermarkForBatch;
                    Gauge gauge = Metrics.gauge((String)NAMESPACE, (String)READ_DURATION_MILLIS);
                    MetricsContainerImpl container = metadata.getMetricsContainers().getContainer(this.stepName);
                    try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)container);){
                        long readDurationMillis = metadata.getReadDurationMillis();
                        if (readDurationMillis > maxReadDuration) {
                            gauge.set(readDurationMillis);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    ((MetricsContainerStepMap)metricsAccum.value()).updateAll(metadata.getMetricsContainers());
                }
                sparkWatermark = new GlobalWatermarkHolder.SparkWatermarks(globalLowWatermarkForBatch, globalHighWatermarkForBatch, new Instant(validTime.milliseconds()));
                GlobalWatermarkHolder.add(this.inputDStreamId, sparkWatermark);
            }
            this.report(validTime, count, sparkWatermark);
            return Option.empty();
        }

        private void report(Time batchTime, long count, GlobalWatermarkHolder.SparkWatermarks sparkWatermark) {
            Map.Map1 metadata = new Map.Map1((Object)StreamInputInfo.METADATA_KEY_DESCRIPTION(), (Object)String.format("Read %d records with observed watermarks %s, from %s for batch time: %s", count, sparkWatermark == null ? "N/A" : sparkWatermark, this.sourceName, batchTime));
            StreamInputInfo streamInputInfo = new StreamInputInfo(this.inputDStreamId, count, (Map)metadata);
            this.ssc().scheduler().inputInfoTracker().reportInfo(batchTime, streamInputInfo);
        }
    }
}

