/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.spark.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.spark.repackaged.com.google.common.collect.AbstractIterator;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;

class SparkProcessContext<FnInputT, FnOutputT, OutputT> {
    private final DoFn<FnInputT, FnOutputT> doFn;
    private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
    private final SparkOutputManager<OutputT> outputManager;
    private Iterator<TimerInternals.TimerData> timerDataIterator;

    SparkProcessContext(DoFn<FnInputT, FnOutputT> doFn, DoFnRunner<FnInputT, FnOutputT> doFnRunner, SparkOutputManager<OutputT> outputManager, Iterator<TimerInternals.TimerData> timerDataIterator) {
        this.doFn = doFn;
        this.doFnRunner = doFnRunner;
        this.outputManager = outputManager;
        this.timerDataIterator = timerDataIterator;
    }

    Iterable<OutputT> processPartition(Iterator<WindowedValue<FnInputT>> partition) throws Exception {
        if (!partition.hasNext()) {
            return new ArrayList();
        }
        DoFnInvokers.invokerFor(this.doFn).invokeSetup();
        return this.getOutputIterable(partition, this.doFnRunner);
    }

    private void clearOutput() {
        this.outputManager.clear();
    }

    private Iterator<OutputT> getOutputIterator() {
        return this.outputManager.iterator();
    }

    private Iterable<OutputT> getOutputIterable(Iterator<WindowedValue<FnInputT>> iter, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
        return () -> new ProcCtxtIterator(iter, doFnRunner);
    }

    private class ProcCtxtIterator
    extends AbstractIterator<OutputT> {
        private final Iterator<WindowedValue<FnInputT>> inputIterator;
        private final DoFnRunner<FnInputT, FnOutputT> doFnRunner;
        private Iterator<OutputT> outputIterator;
        private boolean isBundleStarted;
        private boolean isBundleFinished;

        ProcCtxtIterator(Iterator<WindowedValue<FnInputT>> iterator, DoFnRunner<FnInputT, FnOutputT> doFnRunner) {
            this.inputIterator = iterator;
            this.doFnRunner = doFnRunner;
            this.outputIterator = SparkProcessContext.this.getOutputIterator();
        }

        @Override
        protected OutputT computeNext() {
            if (!this.isBundleStarted) {
                this.isBundleStarted = true;
                this.doFnRunner.startBundle();
            }
            try {
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    SparkProcessContext.this.clearOutput();
                    if (this.inputIterator.hasNext()) {
                        this.doFnRunner.processElement(this.inputIterator.next());
                        this.outputIterator = SparkProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (SparkProcessContext.this.timerDataIterator.hasNext()) {
                        this.fireTimer((TimerInternals.TimerData)SparkProcessContext.this.timerDataIterator.next());
                        this.outputIterator = SparkProcessContext.this.getOutputIterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                    this.outputIterator = SparkProcessContext.this.getOutputIterator();
                }
                DoFnInvokers.invokerFor((DoFn)SparkProcessContext.this.doFn).invokeTeardown();
                return this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor((DoFn)SparkProcessContext.this.doFn).invokeTeardown();
                throw re;
            }
        }

        private void fireTimer(TimerInternals.TimerData timer) {
            StateNamespace namespace = timer.getNamespace();
            Preconditions.checkArgument(namespace instanceof StateNamespaces.WindowNamespace);
            BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
            this.doFnRunner.onTimer(timer.getTimerId(), window, timer.getTimestamp(), timer.getDomain());
        }
    }

    static class NoOpStepContext
    implements StepContext {
        NoOpStepContext() {
        }

        public StateInternals stateInternals() {
            throw new UnsupportedOperationException("stateInternals not supported");
        }

        public TimerInternals timerInternals() {
            throw new UnsupportedOperationException("timerInternals not supported");
        }
    }

    static interface SparkOutputManager<T>
    extends DoFnRunners.OutputManager,
    Iterable<T> {
        public void clear();
    }
}

