/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2;

import edu.iu.dsc.tws.api.tset.sets.TSet;
import edu.iu.dsc.tws.api.tset.sets.batch.BatchTSet;
import edu.iu.dsc.tws.tset.TBaseGraph;
import edu.iu.dsc.tws.tset.env.TSetEnvironment;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.twister2.BeamBatchTSetEnvironment;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.Twister2StreamTranslationContext;
import org.apache.beam.runners.twister2.Twister2TranslationContext;
import org.apache.beam.runners.twister2.translators.Twister2BatchPipelineTranslator;
import org.apache.beam.runners.twister2.translators.Twister2PipelineTranslator;
import org.apache.beam.runners.twister2.translators.Twister2StreamPipelineTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Twister2PipelineExecutionEnvironment {
    private static final @UnknownKeyFor @NonNull @Initialized java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(Twister2PipelineExecutionEnvironment.class.getName());
    private final @UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options;
    private @UnknownKeyFor @NonNull @Initialized Twister2TranslationContext twister2TranslationContext;

    public Twister2PipelineExecutionEnvironment(@UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options) {
        this.options = options;
        options.setTSetEnvironment((TSetEnvironment)new BeamBatchTSetEnvironment());
    }

    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        Twister2PipelineTranslator translator;
        TranslationModeDetector detector = new TranslationModeDetector();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)detector);
        if (detector.isStreaming()) {
            LOG.info("Found unbounded PCollection. Switching to streaming execution.");
            this.options.setStreaming(true);
            throw new UnsupportedOperationException("Streaming is not supported currently in the Twister2 Runner");
        }
        if (this.options.isStreaming()) {
            this.twister2TranslationContext = new Twister2StreamTranslationContext(this.options);
            translator = new Twister2StreamPipelineTranslator();
        } else {
            this.twister2TranslationContext = new Twister2BatchTranslationContext(this.options);
            translator = new Twister2BatchPipelineTranslator(this.options, (Twister2BatchTranslationContext)this.twister2TranslationContext);
        }
        translator.translate(pipeline);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BatchTSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
        return this.twister2TranslationContext.getSideInputDataSets();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TSet> getLeaves() {
        return this.twister2TranslationContext.getLeaves();
    }

    protected @UnknownKeyFor @NonNull @Initialized TBaseGraph getTSetGraph() {
        return this.twister2TranslationContext.getEnvironment().getGraph();
    }

    private static class TranslationModeDetector
    extends Pipeline.PipelineVisitor.Defaults {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TranslationModeDetector.class);
        private @UnknownKeyFor @NonNull @Initialized boolean isStreaming = false;

        TranslationModeDetector() {
        }

        @UnknownKeyFor @NonNull @Initialized boolean isStreaming() {
            return this.isStreaming;
        }

        public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
            if (!this.isStreaming && value instanceof PCollection && ((PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                LOG.info("Found unbounded PCollection {}. Switching to streaming execution.", (Object)value.getName());
                this.isStreaming = true;
            }
        }
    }
}

