/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2;

import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.Twister2Runner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Twister2TestRunner
extends PipelineRunner<PipelineResult> {
    private @UnknownKeyFor @NonNull @Initialized Twister2Runner delegate;

    public Twister2TestRunner(@UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options) {
        options.setRunner(Twister2TestRunner.class);
        options.setParallelism(1);
        this.delegate = Twister2Runner.fromOptions(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized Twister2TestRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Twister2PipelineOptions pipelineOptions = (Twister2PipelineOptions)PipelineOptionsValidator.validate(Twister2PipelineOptions.class, (PipelineOptions)options);
        return new Twister2TestRunner(pipelineOptions);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        try {
            return this.delegate.runTest(pipeline);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Throwable t) {
            RuntimeException exception = new RuntimeException(t.getCause().getMessage(), t.getCause().getCause());
            exception.setStackTrace(t.getCause().getStackTrace());
            throw exception;
        }
    }
}

