/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2;

import edu.iu.dsc.tws.api.tset.sets.TSet;
import edu.iu.dsc.tws.api.tset.sets.batch.BatchTSet;
import edu.iu.dsc.tws.tset.env.TSetEnvironment;
import edu.iu.dsc.tws.tset.sets.batch.SinkTSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class Twister2TranslationContext {
    private final @UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options;
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized TSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataSets = new LinkedHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TSet> leaves = new LinkedHashSet<TSet>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BatchTSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputDataSets;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform;
    private final @UnknownKeyFor @NonNull @Initialized TSetEnvironment environment;

    public Twister2TranslationContext(@UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options) {
        this.options = options;
        this.environment = options.getTSetEnvironment();
        this.sideInputDataSets = new LinkedHashMap();
    }

    public <T extends PValue> T getOutput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public @UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions getOptions() {
        return this.options;
    }

    public <T> void setOutputDataSet(@UnknownKeyFor @NonNull @Initialized PCollection<T> output, @UnknownKeyFor @NonNull @Initialized TSet<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> tset) {
        if (!this.dataSets.containsKey(output)) {
            this.dataSets.put((PValue)output, tset);
            this.leaves.add(tset);
        }
    }

    public <T> @UnknownKeyFor @NonNull @Initialized TSet<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getInputDataSet(@UnknownKeyFor @NonNull @Initialized PValue input) {
        TSet<?> tSet = this.dataSets.get(input);
        this.leaves.remove(tSet);
        return tSet;
    }

    public <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs() {
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform)));
    }

    public void setCurrentTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        this.currentTransform = transform;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs() {
        return this.getCurrentTransform().getOutputs();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    public @UnknownKeyFor @NonNull @Initialized TSetEnvironment getEnvironment() {
        return this.environment;
    }

    public abstract void eval(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SinkTSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

    public <ViewT, ElemT> void setSideInputDataSet(@UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized BatchTSet<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> set) {
        if (!this.sideInputDataSets.containsKey(value)) {
            this.sideInputDataSets.put(value, set);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TSet> getLeaves() {
        return this.leaves;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BatchTSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputDataSets() {
        return this.sideInputDataSets;
    }
}

