/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.translators.BatchTransformTranslator;
import org.apache.beam.runners.twister2.translators.Twister2PipelineTranslator;
import org.apache.beam.runners.twister2.translators.batch.AssignWindowTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.FlattenTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.GroupByKeyTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.ImpulseTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.PCollectionViewTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.ParDoMultiOutputTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.ReadSourceTranslatorBatch;
import org.apache.beam.sdk.transforms.PTransform;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Twister2BatchPipelineTranslator
extends Twister2PipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(Twister2BatchPipelineTranslator.class.getName());
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BatchTransformTranslator> TRANSFORM_TRANSLATORS = new HashMap<String, BatchTransformTranslator>();
    private final @UnknownKeyFor @NonNull @Initialized Twister2BatchTranslationContext translationContext;

    public Twister2BatchPipelineTranslator(@UnknownKeyFor @NonNull @Initialized Twister2PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Twister2BatchTranslationContext twister2TranslationContext) {
        this.translationContext = twister2TranslationContext;
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.fine(String.format("visiting transform %s", node.getTransform()));
        PTransform transform = node.getTransform();
        BatchTransformTranslator<?> translator = this.getTransformTranslator(transform);
        if (null == translator) {
            throw new IllegalStateException("no translator registered for " + transform);
        }
        this.translationContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        translator.translateNode(transform, this.translationContext);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BatchTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTransformTranslator(@UnknownKeyFor @NonNull @Initialized PTransform transform) {
        @Nullable String urn = PTransformTranslation.urnForTransformOrNull((PTransform)transform);
        return urn == null ? null : TRANSFORM_TRANSLATORS.get(urn);
    }

    static {
        TRANSFORM_TRANSLATORS.put("beam:transform:impulse:v1", new ImpulseTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:read:v1", new ReadSourceTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:pardo:v1", new ParDoMultiOutputTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:group_by_key:v1", new GroupByKeyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:flatten:v1", new FlattenTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:create_view:v1", new PCollectionViewTranslatorBatch());
        TRANSFORM_TRANSLATORS.put("beam:transform:window_into:v1", new AssignWindowTranslatorBatch());
    }
}

