/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.batch;

import edu.iu.dsc.tws.api.tset.sets.batch.BatchTSet;
import edu.iu.dsc.tws.tset.sets.batch.BatchTSetImpl;
import java.io.IOException;
import org.apache.beam.runners.core.construction.CreatePCollectionViewTranslation;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.translators.BatchTransformTranslator;
import org.apache.beam.runners.twister2.translators.functions.ByteToElemFunction;
import org.apache.beam.runners.twister2.translators.functions.ByteToWindowFunctionPrimitive;
import org.apache.beam.runners.twister2.translators.functions.ElemToBytesFunction;
import org.apache.beam.runners.twister2.translators.functions.MapToTupleFunction;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PCollectionViewTranslatorBatch<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
implements BatchTransformTranslator<View.CreatePCollectionView<ElemT, ViewT>> {
    @Override
    public void translateNode(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<ElemT, ViewT> transform, @UnknownKeyFor @NonNull @Initialized Twister2BatchTranslationContext context) {
        PCollectionView input;
        BatchTSetImpl inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
        AppliedPTransform<?, ?, ?> application = context.getCurrentTransform();
        PCollection inputPCol = (PCollection)context.getInput(transform);
        Coder coder = inputPCol.getCoder();
        WindowingStrategy windowingStrategy = inputPCol.getWindowingStrategy();
        WindowFn windowFn = windowingStrategy.getWindowFn();
        try {
            input = CreatePCollectionViewTranslation.getView(application);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        switch (input.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:multimap:v1": {
                KvCoder kvCoder = (KvCoder)coder;
                Coder keyCoder = kvCoder.getKeyCoder();
                WindowedValue.FullWindowedValueCoder kvwvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)kvCoder.getValueCoder(), (Coder)windowFn.windowCoder());
                BatchTSet multimapMaterialization = inputDataSet.direct().map(new MapToTupleFunction(keyCoder, kvwvCoder)).allGather().map(new ByteToWindowFunctionPrimitive(keyCoder, kvwvCoder));
                context.setSideInputDataSet(input.getTagInternal().getId(), multimapMaterialization);
                break;
            }
            case "beam:side_input:iterable:v1": {
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowFn.windowCoder());
                BatchTSet iterableMaterialization = inputDataSet.direct().map(new ElemToBytesFunction(wvCoder)).allGather().map(new ByteToElemFunction(wvCoder));
                try {
                    input = CreatePCollectionViewTranslation.getView(application);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                context.setSideInputDataSet(input.getTagInternal().getId(), iterableMaterialization);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown side input materialization " + input.getViewFn().getMaterialization().getUrn());
            }
        }
    }
}

