/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.batch;

import edu.iu.dsc.tws.tset.sets.batch.BatchTSetImpl;
import edu.iu.dsc.tws.tset.sets.batch.ComputeTSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.translators.BatchTransformTranslator;
import org.apache.beam.runners.twister2.translators.functions.DoFnFunction;
import org.apache.beam.runners.twister2.translators.functions.OutputTagFilter;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ParDoMultiOutputTranslatorBatch<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements BatchTransformTranslator<ParDo.MultiOutput<InputT, OutputT>> {
    @Override
    public void translateNode(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized Twister2BatchTranslationContext context) {
        TupleTag mainOutputTag;
        DoFn doFn = transform.getFn();
        if (DoFnSignatures.signatureForDoFn((DoFn)doFn).processElement().isSplittable()) {
            throw new UnsupportedOperationException(String.format("Not expected to directly translate splittable DoFn, should have been overridden: %s", doFn));
        }
        BatchTSetImpl inputTTSet = context.getInputDataSet((PValue)context.getInput(transform));
        WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
        Coder inputCoder = ((PCollection)context.getInput(transform)).getCoder();
        Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs();
        Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
        DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
        Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
        TupleTag mainOutput = transform.getMainOutputTag();
        ArrayList additionalOutputTags = new ArrayList(transform.getAdditionalOutputTags().getAll());
        Map sideInputs = transform.getSideInputs();
        HashMap sideInputStrategies = new HashMap();
        for (PCollectionView sideInput : sideInputs.values()) {
            sideInputStrategies.put(sideInput, sideInput.getWindowingStrategyInternal());
        }
        try {
            mainOutputTag = ParDoTranslation.getMainOutputTag(context.getCurrentTransform());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap outputMap = Maps.newHashMap();
        outputMap.put(mainOutputTag, 0);
        int count = 1;
        for (TupleTag<?> tag : outputs.keySet()) {
            if (outputMap.containsKey(tag)) continue;
            outputMap.put(tag, count++);
        }
        ComputeTSet outputTSet = inputTTSet.direct().compute(new DoFnFunction(context, doFn, inputCoder, outputCoders, additionalOutputTags, windowingStrategy, sideInputStrategies, mainOutput, doFnSchemaInformation, outputMap, sideInputMapping));
        for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
            ComputeTSet tempTSet = outputTSet.direct().compute(new OutputTagFilter((Integer)outputMap.get(output.getKey())));
            context.setOutputDataSet(output.getValue(), tempTSet);
        }
    }
}

