/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.ComputeCollectorFunc;
import edu.iu.dsc.tws.api.tset.fn.RecordCollector;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.twister2.utils.Twister2AssignContext;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.InvalidProtocolBufferException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class AssignWindowsFunction<@UnknownKeyFor T>
implements ComputeCollectorFunc<WindowedValue<T>, Iterator<WindowedValue<T>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(AssignWindowsFunction.class.getName());
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private transient @UnknownKeyFor @NonNull @Initialized WindowFn<T, @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowFn;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] windowFnBytes;

    public AssignWindowsFunction(@UnknownKeyFor @NonNull @Initialized WindowFn<T, @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowFn, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.windowFn = windowFn;
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createOrGetDefaultEnvironment((PortablePipelineOptions)((PortablePipelineOptions)options.as(PortablePipelineOptions.class))));
        RunnerApi.FunctionSpec windowFnProto = WindowingStrategyTranslation.toProto(windowFn, (SdkComponents)components);
        this.windowFnBytes = windowFnProto.toByteArray();
    }

    public void compute(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> input, @UnknownKeyFor @NonNull @Initialized RecordCollector<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> output) {
        try {
            while (input.hasNext()) {
                WindowedValue<T> element = input.next();
                Collection windows = this.windowFn.assignWindows(new Twister2AssignContext<T, BoundedWindow>(this.windowFn, element));
                for (BoundedWindow window : windows) {
                    output.collect((Object)WindowedValue.of((Object)element.getValue(), (Instant)element.getTimestamp(), (BoundedWindow)window, (PaneInfo)element.getPane()));
                }
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public void prepare(@UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.initTransient();
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        try {
            RunnerApi.FunctionSpec windowFnProto = RunnerApi.FunctionSpec.parseFrom((byte[])this.windowFnBytes);
            this.windowFn = WindowingStrategyTranslation.windowFnFromProto((RunnerApi.FunctionSpec)windowFnProto);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.info(e.getMessage());
        }
        this.isInitialized = true;
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }
}

