/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.comms.structs.Tuple;
import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.MapFunc;
import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.twister2.utils.TranslationUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ByteToWindowFunction<@UnknownKeyFor K, @UnknownKeyFor V>
implements MapFunc<KV<K, Iterable<WindowedValue<V>>>, Tuple<byte[], Iterator<byte[]>>> {
    private transient @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(ByteToWindowFunction.class.getName());
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] keyCoderBytes;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] wvCoderBytes;

    public ByteToWindowFunction() {
        this.isInitialized = false;
    }

    public ByteToWindowFunction(@UnknownKeyFor @NonNull @Initialized Coder<K> inputKeyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder) {
        this.keyCoder = inputKeyCoder;
        this.wvCoder = wvCoder;
        this.keyCoderBytes = SerializableUtils.serializeToByteArray(this.keyCoder);
        this.wvCoderBytes = SerializableUtils.serializeToByteArray(wvCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>> map(@UnknownKeyFor @NonNull @Initialized Tuple<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
        Object key = null;
        Iterable value = null;
        try {
            key = CoderUtils.decodeFromByteArray(this.keyCoder, (byte[])((byte[])input.getKey()));
            value = StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)input.getValue(), 16), false).map((? super T bytes) -> TranslationUtils.fromByteArray(bytes, this.wvCoder)).collect(Collectors.toList());
        }
        catch (CoderException e) {
            LOG.info(e.getMessage());
        }
        return KV.of((Object)key, value);
    }

    public void prepare(@UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.initTransient();
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        this.keyCoder = (Coder)SerializableUtils.deserializeFromByteArray((byte[])this.keyCoderBytes, (String)"Custom Coder Bytes");
        this.wvCoder = (WindowedValue.WindowedValueCoder)SerializableUtils.deserializeFromByteArray((byte[])this.wvCoderBytes, (String)"Custom Coder Bytes");
        this.isInitialized = true;
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }
}

