/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.ComputeCollectorFunc;
import edu.iu.dsc.tws.api.tset.fn.RecordCollector;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.twister2.Twister2TranslationContext;
import org.apache.beam.runners.twister2.utils.NoOpStepContext;
import org.apache.beam.runners.twister2.utils.Twister2SideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.DoFnWithExecutionInformation;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.InvalidProtocolBufferException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DoFnFunction<@UnknownKeyFor OutputT, @UnknownKeyFor InputT>
implements ComputeCollectorFunc<RawUnionValue, Iterator<WindowedValue<InputT>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(DoFnFunction.class.getName());
    private transient @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -5701440128544343353L;
    private transient @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs;
    private transient @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutput;
    private transient @UnknownKeyFor @NonNull @Initialized Twister2SideInputReader sideInputReader;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnOutputManager outputManager;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideOutputs;
    private @UnknownKeyFor @NonNull @Initialized StepContext stepcontext;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnInvoker doFnInvoker;
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec doFnwithEx;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] doFnwithExBytes;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] coderBytes;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> outputCodersBytes;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.MessageWithComponents windowStrategyProto;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] windowBytes;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> sideInputBytes;
    private @UnknownKeyFor @NonNull @Initialized String serializedOptions;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> serializedSideOutputs;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> serializedOutputMap;

    public DoFnFunction() {
        this.isInitialized = false;
    }

    public DoFnFunction(@UnknownKeyFor @NonNull @Initialized Twister2TranslationContext context, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideOutputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutput, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        this.doFn = doFn;
        this.pipelineOptions = context.getOptions();
        this.serializedOptions = new SerializablePipelineOptions(this.pipelineOptions).toString();
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = this.convertToTuples(sideInputs);
        this.mainOutput = mainOutput;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideOutputs = sideOutputs;
        this.stepcontext = new NoOpStepContext();
        this.outputMap = outputMap;
        this.sideInputMapping = sideInputMapping;
        this.outputManager = new DoFnOutputManager(this.outputMap);
        this.prepareSerialization();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> convertToTuples(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs) {
        HashMap temp = new HashMap();
        for (Map.Entry<PCollectionView<?>, WindowingStrategy<?, ?>> entry : sideInputs.entrySet()) {
            temp.put(entry.getKey().getTagInternal(), entry.getValue());
        }
        return temp;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSideInputKeys() {
        this.initTransient();
        HashSet<String> keys = new HashSet<String>();
        for (TupleTag<?> view : this.sideInputs.keySet()) {
            keys.add(view.getId());
        }
        return keys;
    }

    public void prepare(@UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.initTransient();
        this.sideInputReader = new Twister2SideInputReader(this.sideInputs, context);
        this.outputManager.setup(this.mainOutput, this.sideOutputs);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)this.pipelineOptions);
        this.doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.pipelineOptions, this.doFn, (SideInputReader)this.sideInputReader, (DoFnRunners.OutputManager)this.outputManager, this.mainOutput, this.sideOutputs, (StepContext)this.stepcontext, this.inputCoder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
    }

    public void compute(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> input, @UnknownKeyFor @NonNull @Initialized RecordCollector<@UnknownKeyFor @NonNull @Initialized RawUnionValue> output) {
        try {
            this.outputManager.clear();
            this.doFnRunner.startBundle();
            while (input.hasNext()) {
                this.doFnRunner.processElement(input.next());
            }
            this.doFnRunner.finishBundle();
            Iterator<RawUnionValue> outputs = this.outputManager.getOutputs();
            while (outputs.hasNext()) {
                output.collect((Object)outputs.next());
            }
        }
        catch (RuntimeException re) {
            DoFnInvokers.invokerFor(this.doFn).invokeTeardown();
            throw re;
        }
    }

    public void close() {
        Optional.ofNullable(this.doFnInvoker).ifPresent(DoFnInvoker::invokeTeardown);
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }

    private void prepareSerialization() {
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createOrGetDefaultEnvironment((PortablePipelineOptions)((PortablePipelineOptions)this.pipelineOptions.as(PortablePipelineOptions.class))));
        this.serializedOptions = new SerializablePipelineOptions(this.pipelineOptions).toString();
        this.doFnwithEx = ParDoTranslation.translateDoFn(this.doFn, this.mainOutput, this.sideInputMapping, (DoFnSchemaInformation)this.doFnSchemaInformation, (SdkComponents)components);
        this.doFnwithExBytes = this.doFnwithEx.getPayload().toByteArray();
        this.outputCodersBytes = new HashMap<String, byte[]>();
        try {
            this.coderBytes = SerializableUtils.serializeToByteArray(this.inputCoder);
            this.windowStrategyProto = WindowingStrategyTranslation.toMessageProto(this.windowingStrategy, (SdkComponents)components);
            this.windowBytes = this.windowStrategyProto.toByteArray();
            for (Map.Entry<TupleTag<?>, Coder<?>> entry : this.outputCoders.entrySet()) {
                this.outputCodersBytes.put(entry.getKey().getId(), SerializableUtils.serializeToByteArray((Serializable)((Serializable)entry.getValue())));
            }
            this.sideInputBytes = new HashMap<String, byte[]>();
            for (Map.Entry<TupleTag<?>, Coder<?>> entry : this.sideInputs.entrySet()) {
                this.windowStrategyProto = WindowingStrategyTranslation.toMessageProto((WindowingStrategy)((WindowingStrategy)entry.getValue()), (SdkComponents)components);
                this.sideInputBytes.put(entry.getKey().getId(), this.windowStrategyProto.toByteArray());
            }
            this.serializedSideOutputs = new ArrayList<String>();
            for (TupleTag tupleTag : this.sideOutputs) {
                this.serializedSideOutputs.add(tupleTag.getId());
            }
            this.serializedOutputMap = new HashMap<String, Integer>();
            for (Map.Entry<TupleTag<?>, Object> entry : this.outputMap.entrySet()) {
                this.serializedOutputMap.put(entry.getKey().getId(), (Integer)entry.getValue());
            }
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        try {
            SdkComponents components = SdkComponents.create();
            this.pipelineOptions = new SerializablePipelineOptions(this.serializedOptions).get();
            DoFnWithExecutionInformation doFnWithExecutionInformation = (DoFnWithExecutionInformation)SerializableUtils.deserializeFromByteArray((byte[])this.doFnwithExBytes, (String)"Custom Coder Bytes");
            this.doFn = doFnWithExecutionInformation.getDoFn();
            this.mainOutput = doFnWithExecutionInformation.getMainOutputTag();
            this.sideInputMapping = doFnWithExecutionInformation.getSideInputMapping();
            this.doFnSchemaInformation = doFnWithExecutionInformation.getSchemaInformation();
            this.inputCoder = (Coder)SerializableUtils.deserializeFromByteArray((byte[])this.coderBytes, (String)"Custom Coder Bytes");
            this.windowStrategyProto = RunnerApi.MessageWithComponents.parseFrom((byte[])this.windowBytes);
            this.windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)this.windowStrategyProto.getWindowingStrategy(), (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)components.toComponents()));
            this.sideInputs = new HashMap();
            for (Map.Entry<String, byte[]> entry : this.sideInputBytes.entrySet()) {
                this.windowStrategyProto = RunnerApi.MessageWithComponents.parseFrom((byte[])entry.getValue());
                this.sideInputs.put(new TupleTag(entry.getKey()), WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)this.windowStrategyProto.getWindowingStrategy(), (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)components.toComponents())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.info(e.getMessage());
        }
        this.outputCoders = new HashMap();
        for (Map.Entry<String, byte[]> entry : this.outputCodersBytes.entrySet()) {
            this.outputCoders.put(new TupleTag(entry.getKey()), (Coder)SerializableUtils.deserializeFromByteArray((byte[])entry.getValue(), (String)"Custom Coder Bytes"));
        }
        this.sideOutputs = new ArrayList();
        for (String string : this.serializedSideOutputs) {
            this.sideOutputs.add(new TupleTag(string));
        }
        this.outputMap = new HashMap();
        for (Map.Entry entry : this.serializedOutputMap.entrySet()) {
            this.outputMap.put(new TupleTag((String)entry.getKey()), (Integer)entry.getValue());
        }
        this.outputManager = new DoFnOutputManager(this.outputMap);
        this.isInitialized = true;
    }

    private static class DoFnOutputManager
    implements DoFnRunners.OutputManager,
    Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 4967375172737408160L;
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RawUnionValue> outputs;
        private transient /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTags;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;

        private DoFnOutputManager() {
        }

        DoFnOutputManager(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap) {
            this.outputMap = outputMap;
        }

        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> outputTag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            if (this.outputTags.contains(outputTag)) {
                this.outputs.add(new RawUnionValue(this.outputMap.get(outputTag).intValue(), output));
            }
        }

        void setup(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> mainOutput, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideOutputs) {
            this.outputs = new ArrayList<RawUnionValue>();
            this.outputTags = new HashSet();
            this.outputTags.add(mainOutput);
            this.outputTags.addAll(sideOutputs);
        }

        void clear() {
            this.outputs.clear();
        }

        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> getOutputs() {
            return this.outputs.iterator();
        }
    }
}

