/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.MapFunc;
import java.io.ObjectStreamException;
import java.util.logging.Logger;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ElemToBytesFunction<@UnknownKeyFor V>
implements MapFunc<byte[], WindowedValue<V>> {
    private transient // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(ElemToBytesFunction.class.getName());
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] wvCoderBytes;

    public ElemToBytesFunction() {
        this.isInitialized = false;
    }

    public ElemToBytesFunction(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder) {
        this.wvCoder = wvCoder;
        this.wvCoderBytes = SerializableUtils.serializeToByteArray(wvCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] map(@UnknownKeyFor @NonNull @Initialized WindowedValue<V> input) {
        try {
            return CoderUtils.encodeToByteArray(this.wvCoder, input);
        }
        catch (CoderException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    public void prepare(@UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.initTransient();
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        this.wvCoder = (WindowedValue.WindowedValueCoder)SerializableUtils.deserializeFromByteArray((byte[])this.wvCoderBytes, (String)"Coder");
        this.isInitialized = true;
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }
}

