/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.comms.structs.Tuple;
import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.MapFunc;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class MapToTupleFunction<@UnknownKeyFor K, @UnknownKeyFor V>
implements MapFunc<Tuple<byte[], byte[]>, WindowedValue<KV<K, V>>> {
    private transient @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(MapToTupleFunction.class.getName());
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] keyCoderBytes;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] wvCoderBytes;

    public MapToTupleFunction() {
        this.isInitialized = false;
    }

    public MapToTupleFunction(@UnknownKeyFor @NonNull @Initialized Coder<K> inputKeyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder) {
        this.keyCoder = inputKeyCoder;
        this.wvCoder = wvCoder;
        this.keyCoderBytes = SerializableUtils.serializeToByteArray(this.keyCoder);
        this.wvCoderBytes = SerializableUtils.serializeToByteArray(wvCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Tuple<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> map(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        Tuple element = null;
        WindowedValue temp = WindowedValue.of((Object)KV.of((Object)((KV)input.getValue()).getKey(), (Object)WindowedValue.of((Object)((KV)input.getValue()).getValue(), (Instant)input.getTimestamp(), (Collection)input.getWindows(), (PaneInfo)input.getPane())), (Instant)input.getTimestamp(), (Collection)input.getWindows(), (PaneInfo)input.getPane());
        try {
            element = new Tuple((Object)CoderUtils.encodeToByteArray(this.keyCoder, (Object)((KV)temp.getValue()).getKey()), (Object)CoderUtils.encodeToByteArray(this.wvCoder, (Object)((WindowedValue)((KV)temp.getValue()).getValue())));
        }
        catch (CoderException e) {
            LOG.info(e.getMessage());
        }
        return element;
    }

    public void prepare(@UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.initTransient();
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        this.keyCoder = (Coder)SerializableUtils.deserializeFromByteArray((byte[])this.keyCoderBytes, (String)"Coder");
        this.wvCoder = (WindowedValue.WindowedValueCoder)SerializableUtils.deserializeFromByteArray((byte[])this.wvCoderBytes, (String)"Coder");
        this.isInitialized = true;
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }
}

