/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions.internal;

import java.io.ObjectStreamException;
import org.apache.beam.runners.core.MergingStateAccessor;
import org.apache.beam.runners.core.StateAccessor;
import org.apache.beam.runners.core.StateMerging;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SerializableUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SystemReduceFnBuffering<@UnknownKeyFor K, @UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends SystemReduceFn<K, T, Iterable<T>, Iterable<T>, W> {
    private static final @UnknownKeyFor @NonNull @Initialized String BUFFER_NAME = "buf";
    private transient @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> bufferTagLocal;
    private transient @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder;
    private transient @UnknownKeyFor @NonNull @Initialized boolean isInitialized = false;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] coderBytes;

    public SystemReduceFnBuffering() {
        super(null);
        this.isInitialized = false;
    }

    public SystemReduceFnBuffering(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        super(null);
        this.bufferTagLocal = null;
        this.coderBytes = SerializableUtils.serializeToByteArray(valueCoder);
        this.inputCoder = valueCoder;
    }

    public void onMerge(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.initTransient();
        StateMerging.mergeBags((MergingStateAccessor)context.state(), this.bufferTagLocal);
    }

    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.initTransient();
        StateMerging.prefetchBags(state, this.bufferTagLocal);
    }

    public void processValue(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized ProcessValueContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.initTransient();
        ((BagState)c.state().access(this.bufferTagLocal)).add(c.value());
    }

    public void prefetchOnTrigger(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        this.initTransient();
        ((BagState)state.access(this.bufferTagLocal)).readLater();
    }

    public void onTrigger(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnTriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.initTransient();
        c.output((Object)((BagState)c.state().access(this.bufferTagLocal)).read());
    }

    public void clearState(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.initTransient();
        ((BagState)c.state().access(this.bufferTagLocal)).clear();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        this.initTransient();
        return ((BagState)state.access(this.bufferTagLocal)).isEmpty();
    }

    private void initTransient() {
        if (this.isInitialized) {
            return;
        }
        this.inputCoder = (Coder)SerializableUtils.deserializeFromByteArray((byte[])this.coderBytes, (String)"Custom Coder Bytes");
        this.bufferTagLocal = StateTags.makeSystemTagInternal((StateTag)StateTags.bag((String)BUFFER_NAME, this.inputCoder));
        this.isInitialized = true;
    }

    protected @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return this;
    }
}

