/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.utils;

import edu.iu.dsc.tws.api.dataset.DataPartition;
import edu.iu.dsc.tws.api.dataset.DataPartitionConsumer;
import edu.iu.dsc.tws.api.tset.TSetContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Twister2SideInputReader
implements SideInputReader {
    private final @UnknownKeyFor @NonNull @Initialized TSetContext runtimeContext;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs;

    public Twister2SideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> indexByView, @UnknownKeyFor @NonNull @Initialized TSetContext context) {
        this.sideInputs = indexByView;
        this.runtimeContext = context;
    }

    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
        TupleTag tag = view.getTagInternal();
        Preconditions.checkNotNull(this.sideInputs.get(tag), (Object)("Side input for " + view + " not available."));
        return this.getSideInput(view, window);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return false;
    }

    private <T> T getSideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:multimap:v1": {
                return this.getMultimapSideInput(view, window);
            }
            case "beam:side_input:iterable:v1": {
                return this.getIterableSideInput(view, window);
            }
        }
        throw new IllegalArgumentException("Unknown materialization type: " + view.getViewFn().getMaterialization().getUrn());
    }

    private <T> T getMultimapSideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Map<BoundedWindow, List<WindowedValue<?>>> partitionedElements = this.getPartitionedElements(view);
        HashMap<BoundedWindow, Object> resultMap = new HashMap<BoundedWindow, Object>();
        ViewFn viewFn = view.getViewFn();
        for (Map.Entry<BoundedWindow, List<WindowedValue<?>>> elements : partitionedElements.entrySet()) {
            Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
            resultMap.put(elements.getKey(), viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)elements.getValue().stream().map(WindowedValue::getValue).collect(Collectors.toList()))));
        }
        Object result = resultMap.get(window);
        if (result == null) {
            result = viewFn.apply((Object)InMemoryMultimapSideInputView.empty());
        }
        return (T)result;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getPartitionedElements(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view) {
        HashMap partitionedElements = new HashMap();
        DataPartition sideInput = this.runtimeContext.getInput(view.getTagInternal().getId());
        DataPartitionConsumer dataPartitionConsumer = sideInput.getConsumer();
        while (dataPartitionConsumer.hasNext()) {
            WindowedValue winValue = (WindowedValue)dataPartitionConsumer.next();
            for (BoundedWindow tbw : winValue.getWindows()) {
                List windowedValues = partitionedElements.computeIfAbsent(tbw, k -> new ArrayList());
                windowedValues.add(winValue);
            }
        }
        return partitionedElements;
    }

    private <T> T getIterableSideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Map<BoundedWindow, List<WindowedValue<?>>> partitionedElements = this.getPartitionedElements(view);
        ViewFn viewFn = view.getViewFn();
        HashMap<BoundedWindow, Object> resultMap = new HashMap<BoundedWindow, Object>();
        for (Map.Entry<BoundedWindow, List<WindowedValue<?>>> elements : partitionedElements.entrySet()) {
            resultMap.put(elements.getKey(), viewFn.apply(() -> ((List)elements.getValue()).stream().map(WindowedValue::getValue).collect(Collectors.toList())));
        }
        Object result = resultMap.get(window);
        if (result == null) {
            result = viewFn.apply(() -> Collections.emptyList());
        }
        return (T)result;
    }
}

