package org.apache.beam.sdk.common.runner.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * Job Service for running RunnerAPI pipelines
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.2.0)",
    comments = "Source: beam_job_api.proto")
public final class JobServiceGrpc {

  private JobServiceGrpc() {}

  public static final String SERVICE_NAME = "org.apache.beam.runner_api.v1.JobService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse> METHOD_PREPARE =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "Prepare"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse> METHOD_RUN =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "Run"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> METHOD_GET_STATE =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "GetState"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse> METHOD_CANCEL =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "Cancel"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> METHOD_GET_STATE_STREAM =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "GetStateStream"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest,
      org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse> METHOD_GET_MESSAGE_STREAM =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING,
          generateFullMethodName(
              "org.apache.beam.runner_api.v1.JobService", "GetMessageStream"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JobServiceStub newStub(io.grpc.Channel channel) {
    return new JobServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JobServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new JobServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static JobServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new JobServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Job Service for running RunnerAPI pipelines
   * </pre>
   */
  public static abstract class JobServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     * </pre>
     */
    public void prepare(org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_PREPARE, responseObserver);
    }

    /**
     * <pre>
     * Submit the job for execution
     * </pre>
     */
    public void run(org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_RUN, responseObserver);
    }

    /**
     * <pre>
     * Get the current state of the job
     * </pre>
     */
    public void getState(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_STATE, responseObserver);
    }

    /**
     * <pre>
     * Cancel the job
     * </pre>
     */
    public void cancel(org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_CANCEL, responseObserver);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     * </pre>
     */
    public void getStateStream(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_STATE_STREAM, responseObserver);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes and messages from the job
     * </pre>
     */
    public void getMessageStream(org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_MESSAGE_STREAM, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_PREPARE,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse>(
                  this, METHODID_PREPARE)))
          .addMethod(
            METHOD_RUN,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse>(
                  this, METHODID_RUN)))
          .addMethod(
            METHOD_GET_STATE,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse>(
                  this, METHODID_GET_STATE)))
          .addMethod(
            METHOD_CANCEL,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse>(
                  this, METHODID_CANCEL)))
          .addMethod(
            METHOD_GET_STATE_STREAM,
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse>(
                  this, METHODID_GET_STATE_STREAM)))
          .addMethod(
            METHOD_GET_MESSAGE_STREAM,
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest,
                org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse>(
                  this, METHODID_GET_MESSAGE_STREAM)))
          .build();
    }
  }

  /**
   * <pre>
   * Job Service for running RunnerAPI pipelines
   * </pre>
   */
  public static final class JobServiceStub extends io.grpc.stub.AbstractStub<JobServiceStub> {
    private JobServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private JobServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new JobServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     * </pre>
     */
    public void prepare(org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_PREPARE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submit the job for execution
     * </pre>
     */
    public void run(org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_RUN, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the current state of the job
     * </pre>
     */
    public void getState(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_STATE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Cancel the job
     * </pre>
     */
    public void cancel(org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_CANCEL, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     * </pre>
     */
    public void getStateStream(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_GET_STATE_STREAM, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes and messages from the job
     * </pre>
     */
    public void getMessageStream(org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_GET_MESSAGE_STREAM, getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Job Service for running RunnerAPI pipelines
   * </pre>
   */
  public static final class JobServiceBlockingStub extends io.grpc.stub.AbstractStub<JobServiceBlockingStub> {
    private JobServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private JobServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new JobServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     * </pre>
     */
    public org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse prepare(org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_PREPARE, getCallOptions(), request);
    }

    /**
     * <pre>
     * Submit the job for execution
     * </pre>
     */
    public org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse run(org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_RUN, getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the current state of the job
     * </pre>
     */
    public org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse getState(org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_STATE, getCallOptions(), request);
    }

    /**
     * <pre>
     * Cancel the job
     * </pre>
     */
    public org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse cancel(org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_CANCEL, getCallOptions(), request);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     * </pre>
     */
    public java.util.Iterator<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> getStateStream(
        org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_GET_STATE_STREAM, getCallOptions(), request);
    }

    /**
     * <pre>
     * Subscribe to a stream of state changes and messages from the job
     * </pre>
     */
    public java.util.Iterator<org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse> getMessageStream(
        org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_GET_MESSAGE_STREAM, getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Job Service for running RunnerAPI pipelines
   * </pre>
   */
  public static final class JobServiceFutureStub extends io.grpc.stub.AbstractStub<JobServiceFutureStub> {
    private JobServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private JobServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new JobServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse> prepare(
        org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_PREPARE, getCallOptions()), request);
    }

    /**
     * <pre>
     * Submit the job for execution
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse> run(
        org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_RUN, getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the current state of the job
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse> getState(
        org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_STATE, getCallOptions()), request);
    }

    /**
     * <pre>
     * Cancel the job
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse> cancel(
        org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_CANCEL, getCallOptions()), request);
    }
  }

  private static final int METHODID_PREPARE = 0;
  private static final int METHODID_RUN = 1;
  private static final int METHODID_GET_STATE = 2;
  private static final int METHODID_CANCEL = 3;
  private static final int METHODID_GET_STATE_STREAM = 4;
  private static final int METHODID_GET_MESSAGE_STREAM = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final JobServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(JobServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PREPARE:
          serviceImpl.prepare((org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.PrepareJobResponse>) responseObserver);
          break;
        case METHODID_RUN:
          serviceImpl.run((org.apache.beam.sdk.common.runner.v1.JobApi.RunJobRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.RunJobResponse>) responseObserver);
          break;
        case METHODID_GET_STATE:
          serviceImpl.getState((org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse>) responseObserver);
          break;
        case METHODID_CANCEL:
          serviceImpl.cancel((org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.CancelJobResponse>) responseObserver);
          break;
        case METHODID_GET_STATE_STREAM:
          serviceImpl.getStateStream((org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.GetJobStateResponse>) responseObserver);
          break;
        case METHODID_GET_MESSAGE_STREAM:
          serviceImpl.getMessageStream((org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.sdk.common.runner.v1.JobApi.JobMessagesResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class JobServiceDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.beam.sdk.common.runner.v1.JobApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JobServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JobServiceDescriptorSupplier())
              .addMethod(METHOD_PREPARE)
              .addMethod(METHOD_RUN)
              .addMethod(METHOD_GET_STATE)
              .addMethod(METHOD_CANCEL)
              .addMethod(METHOD_GET_STATE_STREAM)
              .addMethod(METHOD_GET_MESSAGE_STREAM)
              .build();
        }
      }
    }
    return result;
  }
}
