/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.google.auto.service.AutoService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.fn.harness.ExternalWorkerService;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.expansion.v1.ExpansionServiceGrpc;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.expansion.service.ExpansionServiceOptions;
import org.apache.beam.sdk.expansion.service.ExpansionServiceSchemaTransformProvider;
import org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProvider;
import org.apache.beam.sdk.expansion.service.TransformProvider;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ServerBuilder;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Converter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpansionService
extends ExpansionServiceGrpc.ExpansionServiceImplBase
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ExpansionService.class);
    private static final @UnknownKeyFor @NonNull @Initialized SchemaRegistry SCHEMA_REGISTRY = SchemaRegistry.createDefault();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformProvider> registeredTransforms;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @Nullable @UnknownKeyFor @Initialized String loopbackAddress;

    private static <ConfigT> @UnknownKeyFor @NonNull @Initialized Class<ConfigT> getConfigClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder<ConfigT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transformBuilder) {
        Class<?> configurationClass = null;
        for (Method method : transformBuilder.getClass().getMethods()) {
            if (!method.getName().equals("buildExternal")) continue;
            Preconditions.checkState((method.getParameterCount() == 1 ? 1 : 0) != 0, (String)"Build method for ExternalTransformBuilder %s must have exactly one parameter, but had %s parameters.", (Object)transformBuilder.getClass().getSimpleName(), (int)method.getParameterCount());
            configurationClass = method.getParameterTypes()[0];
            if (!Object.class.equals(configurationClass)) break;
        }
        if (configurationClass == null) {
            throw new AssertionError((Object)"Failed to find buildExternal method.");
        }
        return configurationClass;
    }

    static <ConfigT> @UnknownKeyFor @NonNull @Initialized Row decodeConfigObjectRow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SchemaApi.Schema schema, @UnknownKeyFor @NonNull @Initialized ByteString payload) {
        Row configRow;
        Schema payloadSchema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)schema);
        if (payloadSchema.getFieldCount() == 0) {
            return Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[0])).build();
        }
        Converter camelCaseConverter = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        payloadSchema = (Schema)payloadSchema.getFields().stream().map(field -> {
            Preconditions.checkNotNull((Object)field.getName());
            if (field.getName().contains("_")) {
                @Nullable String newName = (String)camelCaseConverter.convert((Object)field.getName());
                assert (newName != null) : "@AssumeAssertion(nullness): converter type is imprecise; it is nullness-preserving";
                return field.withName(newName);
            }
            return field;
        }).collect(Schema.toSchema());
        try {
            configRow = (Row)RowCoder.of((Schema)payloadSchema).decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException("Error decoding payload", e);
        }
        return configRow;
    }

    @VisibleForTesting
    public static <ConfigT> ConfigT payloadToConfig(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExternalTransforms.ExternalConfigurationPayload payload, @UnknownKeyFor @NonNull @Initialized Class<ConfigT> configurationClass) {
        try {
            return ExpansionService.payloadToConfigSchema(payload, configurationClass);
        }
        catch (NoSuchSchemaException schemaException) {
            LOG.warn("Configuration class '{}' has no schema registered. Attempting to construct with setter approach.", (Object)configurationClass.getName());
            try {
                return ExpansionService.payloadToConfigSetters(payload, configurationClass);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(String.format("Failed to construct instance of configuration class '%s'", configurationClass.getName()), e);
            }
        }
    }

    private static <ConfigT> ConfigT payloadToConfigSchema(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExternalTransforms.ExternalConfigurationPayload payload, @UnknownKeyFor @NonNull @Initialized Class<ConfigT> configurationClass) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        Schema configSchema = SCHEMA_REGISTRY.getSchema(configurationClass);
        SerializableFunction fromRowFunc = SCHEMA_REGISTRY.getFromRowFunction(configurationClass);
        Row payloadRow = ExpansionService.decodeConfigObjectRow(payload.getSchema(), payload.getPayload());
        if (!payloadRow.getSchema().assignableTo(configSchema)) {
            throw new IllegalArgumentException(String.format("Schema in expansion request payload is not assignable to the schema for the configuration object.%n%nPayload Schema: %s%n%nConfiguration Schema: %s", payloadRow.getSchema(), configSchema));
        }
        return (ConfigT)fromRowFunc.apply((Object)payloadRow);
    }

    private static <ConfigT> ConfigT payloadToConfigSetters(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExternalTransforms.ExternalConfigurationPayload payload, @UnknownKeyFor @NonNull @Initialized Class<ConfigT> configurationClass) throws @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
        Row configRow = ExpansionService.decodeConfigObjectRow(payload.getSchema(), payload.getPayload());
        Constructor<ConfigT> constructor = configurationClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        ConfigT config = constructor.newInstance(new Object[0]);
        for (Schema.Field field : configRow.getSchema().getFields()) {
            Method method;
            String key = field.getName();
            @Nullable Object value = configRow.getValue(field.getName());
            String fieldName = key;
            Coder coder = SchemaCoder.coderForFieldType((Schema.FieldType)field.getType());
            Class type = coder.getEncodedTypeDescriptor().getRawType();
            String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                method = config.getClass().getMethod(setterName, type);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("The configuration class %s is missing a setter %s for %s with type %s", config.getClass(), setterName, fieldName, coder.getEncodedTypeDescriptor().getType().getTypeName()), e);
            }
            ExpansionService.invokeSetter(config, value, method);
        }
        return config;
    }

    private static <ConfigT> void invokeSetter(ConfigT config, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Method method) throws @UnknownKeyFor @NonNull @Initialized IllegalAccessException, @UnknownKeyFor @NonNull @Initialized InvocationTargetException {
        method.invoke(config, value);
    }

    public ExpansionService() {
        this(new String[0]);
    }

    public ExpansionService(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        this(PipelineOptionsFactory.fromArgs((String[])args).create());
    }

    public ExpansionService(@UnknownKeyFor @NonNull @Initialized PipelineOptions opts) {
        this(opts, null);
    }

    public ExpansionService(@UnknownKeyFor @NonNull @Initialized PipelineOptions opts, @Nullable @UnknownKeyFor @Initialized String loopbackAddress) {
        this.pipelineOptions = opts;
        this.loopbackAddress = loopbackAddress;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformProvider> getRegisteredTransforms() {
        if (this.registeredTransforms == null) {
            this.registeredTransforms = this.loadRegisteredTransforms();
        }
        return this.registeredTransforms;
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaTransformProvider> getRegisteredSchemaTransforms() {
        return ExpansionServiceSchemaTransformProvider.of().getAllProviders();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformProvider> loadRegisteredTransforms() {
        ImmutableMap.Builder registeredTransformsBuilder = ImmutableMap.builder();
        for (ExpansionServiceRegistrar registrar : ServiceLoader.load(ExpansionServiceRegistrar.class)) {
            registeredTransformsBuilder.putAll(registrar.knownTransforms());
        }
        ImmutableMap registeredTransforms = registeredTransformsBuilder.build();
        LOG.info("Registering external transforms: {}", (Object)registeredTransforms.keySet());
        return registeredTransforms;
    }

    @VisibleForTesting
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionResponse expand(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionRequest request) {
        boolean isUseDeprecatedRead;
        LOG.info("Expanding '{}' with URN '{}'", (Object)request.getTransform().getUniqueName(), (Object)request.getTransform().getSpec().getUrn());
        LOG.debug("Full transform: {}", (Object)request.getTransform());
        Set existingTransformIds = request.getComponents().getTransformsMap().keySet();
        Pipeline pipeline = this.createPipeline(PipelineOptionsTranslation.fromProto((Struct)request.getPipelineOptions()));
        boolean bl = isUseDeprecatedRead = ExperimentalOptions.hasExperiment((PipelineOptions)this.pipelineOptions, (String)"use_deprecated_read") || ExperimentalOptions.hasExperiment((PipelineOptions)this.pipelineOptions, (String)"beam_fn_api_use_deprecated_read");
        if (!isUseDeprecatedRead) {
            ExperimentalOptions.addExperiment((ExperimentalOptions)((ExperimentalOptions)pipeline.getOptions().as(ExperimentalOptions.class)), (String)"beam_fn_api");
            ExperimentalOptions.addExperiment((ExperimentalOptions)((ExperimentalOptions)pipeline.getOptions().as(ExperimentalOptions.class)), (String)"use_sdf_read");
        } else {
            LOG.warn("Using use_depreacted_read in portable runners is runner-dependent. The ExpansionService will respect that, but if your runner does not have support for native Read transform, your Pipeline will fail during Pipeline submission.");
        }
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)request.getComponents()).withPipeline(pipeline);
        Map<String, PCollection<?>> inputs = request.getTransform().getInputsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, input -> {
            try {
                return rehydratedComponents.getPCollection((String)input.getValue());
            }
            catch (IOException exn) {
                throw new RuntimeException(exn);
            }
        }));
        String urn = request.getTransform().getSpec().getUrn();
        TransformProvider<PCollectionRowTuple, PCollectionRowTuple> transformProvider = null;
        if (BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.JAVA_CLASS_LOOKUP).equals(urn)) {
            JavaClassLookupTransformProvider.AllowList allowList = ((ExpansionServiceOptions)this.pipelineOptions.as(ExpansionServiceOptions.class)).getJavaClassLookupAllowlist();
            assert (allowList != null);
            transformProvider = new JavaClassLookupTransformProvider(allowList);
        } else if (BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM).equals(urn)) {
            transformProvider = ExpansionServiceSchemaTransformProvider.of();
        } else {
            transformProvider = this.getRegisteredTransforms().get(urn);
            if (transformProvider == null) {
                throw new UnsupportedOperationException("Unknown urn: " + request.getTransform().getSpec().getUrn());
            }
        }
        List<String> classpathResources = transformProvider.getDependencies(request.getTransform().getSpec(), pipeline.getOptions());
        ((PortablePipelineOptions)pipeline.getOptions().as(PortablePipelineOptions.class)).setFilesToStage(classpathResources);
        Map<String, PCollection<?>> outputs = transformProvider.apply(pipeline, request.getTransform().getUniqueName(), request.getTransform().getSpec(), inputs);
        SdkComponents sdkComponents = rehydratedComponents.getSdkComponents((Collection)request.getRequirementsList()).withNewIdPrefix(request.getNamespace());
        RunnerApi.Environment defaultEnvironment = Environments.createOrGetDefaultEnvironment((PortablePipelineOptions)((PortablePipelineOptions)pipeline.getOptions().as(PortablePipelineOptions.class)));
        if (((ExpansionServiceOptions)this.pipelineOptions.as(ExpansionServiceOptions.class)).getAlsoStartLoopbackWorker()) {
            PortablePipelineOptions externalOptions = (PortablePipelineOptions)PipelineOptionsFactory.create().as(PortablePipelineOptions.class);
            externalOptions.setDefaultEnvironmentType("EXTERNAL");
            externalOptions.setDefaultEnvironmentConfig(this.loopbackAddress);
            defaultEnvironment = Environments.createAnyOfEnvironment((RunnerApi.Environment[])new RunnerApi.Environment[]{defaultEnvironment, Environments.createOrGetDefaultEnvironment((PortablePipelineOptions)externalOptions)});
        }
        sdkComponents.registerEnvironment(defaultEnvironment);
        Map<String, String> outputMap = outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, output -> {
            try {
                return sdkComponents.registerPCollection((PCollection)output.getValue());
            }
            catch (IOException exn) {
                throw new RuntimeException(exn);
            }
        }));
        if (isUseDeprecatedRead) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary((Pipeline)pipeline);
        }
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)sdkComponents);
        String expandedTransformId = (String)Iterables.getOnlyElement((Iterable)pipelineProto.getRootTransformIdsList().stream().filter(id -> !existingTransformIds.contains(id)).collect(Collectors.toList()));
        RunnerApi.Components components = pipelineProto.getComponents();
        RunnerApi.PTransform expandedTransform = components.getTransformsOrThrow(expandedTransformId).toBuilder().setUniqueName(expandedTransformId).clearOutputs().putAllOutputs(outputMap).build();
        LOG.debug("Expanded to {}", (Object)expandedTransform);
        return ExpansionApi.ExpansionResponse.newBuilder().setComponents(components.toBuilder().removeTransforms(expandedTransformId)).setTransform(expandedTransform).addAllRequirements((Iterable)pipelineProto.getRequirementsList()).build();
    }

    protected @UnknownKeyFor @NonNull @Initialized Pipeline createPipeline(@UnknownKeyFor @NonNull @Initialized PipelineOptions requestOptions) {
        PipelineOptions effectiveOpts = PipelineOptionsFactory.create();
        PortablePipelineOptions portableOptions = (PortablePipelineOptions)effectiveOpts.as(PortablePipelineOptions.class);
        PortablePipelineOptions specifiedOptions = (PortablePipelineOptions)this.pipelineOptions.as(PortablePipelineOptions.class);
        Optional.ofNullable(specifiedOptions.getDefaultEnvironmentType()).ifPresent(arg_0 -> ((PortablePipelineOptions)portableOptions).setDefaultEnvironmentType(arg_0));
        Optional.ofNullable(specifiedOptions.getDefaultEnvironmentConfig()).ifPresent(arg_0 -> ((PortablePipelineOptions)portableOptions).setDefaultEnvironmentConfig(arg_0));
        List filesToStage = specifiedOptions.getFilesToStage();
        if (filesToStage != null) {
            ((PortablePipelineOptions)effectiveOpts.as(PortablePipelineOptions.class)).setFilesToStage(filesToStage);
        }
        ((ExperimentalOptions)effectiveOpts.as(ExperimentalOptions.class)).setExperiments(((ExperimentalOptions)this.pipelineOptions.as(ExperimentalOptions.class)).getExperiments());
        effectiveOpts.setRunner(NotRunnableRunner.class);
        ((ExpansionServiceOptions)effectiveOpts.as(ExpansionServiceOptions.class)).setExpansionServiceConfig(((ExpansionServiceOptions)this.pipelineOptions.as(ExpansionServiceOptions.class)).getExpansionServiceConfig());
        if (((StreamingOptions)requestOptions.as(StreamingOptions.class)).getUpdateCompatibilityVersion() != null) {
            ((StreamingOptions)effectiveOpts.as(StreamingOptions.class)).setUpdateCompatibilityVersion(((StreamingOptions)requestOptions.as(StreamingOptions.class)).getUpdateCompatibilityVersion());
        }
        return Pipeline.create((PipelineOptions)effectiveOpts);
    }

    public void expand(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.ExpansionResponse> responseObserver) {
        try {
            responseObserver.onNext((Object)this.expand(request));
            responseObserver.onCompleted();
        }
        catch (RuntimeException exn) {
            responseObserver.onNext((Object)ExpansionApi.ExpansionResponse.newBuilder().setError(Throwables.getStackTraceAsString((Throwable)exn)).build());
            responseObserver.onCompleted();
        }
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformResponse discover(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformRequest request) {
        ExpansionServiceSchemaTransformProvider transformProvider = ExpansionServiceSchemaTransformProvider.of();
        ExpansionApi.DiscoverSchemaTransformResponse.Builder responseBuilder = ExpansionApi.DiscoverSchemaTransformResponse.newBuilder();
        for (SchemaTransformProvider provider : transformProvider.getAllProviders()) {
            ExpansionApi.SchemaTransformConfig.Builder schemaTransformConfigBuilder = ExpansionApi.SchemaTransformConfig.newBuilder();
            schemaTransformConfigBuilder.setDescription(provider.description());
            schemaTransformConfigBuilder.setConfigSchema(SchemaTranslation.schemaToProto((Schema)provider.configurationSchema(), (boolean)true));
            schemaTransformConfigBuilder.addAllInputPcollectionNames((Iterable)provider.inputCollectionNames());
            schemaTransformConfigBuilder.addAllOutputPcollectionNames((Iterable)provider.outputCollectionNames());
            responseBuilder.putSchemaTransformConfigs(provider.identifier(), schemaTransformConfigBuilder.build());
        }
        return responseBuilder.build();
    }

    public void discoverSchemaTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformRequest request, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ExpansionApi.DiscoverSchemaTransformResponse> responseObserver) {
        try {
            responseObserver.onNext((Object)this.discover(request));
            responseObserver.onCompleted();
        }
        catch (RuntimeException exn) {
            responseObserver.onNext((Object)ExpansionApi.DiscoverSchemaTransformResponse.newBuilder().setError(Throwables.getStackTraceAsString((Throwable)exn)).build());
            responseObserver.onCompleted();
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int port = Integer.parseInt(args[0]);
        System.out.println("Starting expansion service at localhost:" + port);
        PipelineOptionsFactory.register(ExpansionServiceOptions.class);
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOfRange(args, 1, args.length)).create();
        ExpansionService service = new ExpansionService(options, "localhost:" + port);
        StringBuilder registeredTransformsLog = new StringBuilder();
        boolean registeredTransformsFound = false;
        registeredTransformsLog.append("\n");
        registeredTransformsLog.append("Registered transforms:");
        for (Map.Entry<String, TransformProvider> entry : service.getRegisteredTransforms().entrySet()) {
            registeredTransformsFound = true;
            registeredTransformsLog.append("\n\t" + entry.getKey() + ": " + entry.getValue());
        }
        StringBuilder registeredSchemaTransformProvidersLog = new StringBuilder();
        boolean registeredSchemaTransformProvidersFound = false;
        registeredSchemaTransformProvidersLog.append("\n");
        registeredSchemaTransformProvidersLog.append("Registered SchemaTransformProviders:");
        for (SchemaTransformProvider provider : service.getRegisteredSchemaTransforms()) {
            registeredSchemaTransformProvidersFound = true;
            registeredSchemaTransformProvidersLog.append("\n\t" + provider.identifier());
        }
        if (registeredTransformsFound) {
            System.out.println(registeredTransformsLog.toString());
        }
        if (registeredSchemaTransformProvidersFound) {
            System.out.println(registeredSchemaTransformProvidersLog.toString());
        }
        if (!registeredTransformsFound && !registeredSchemaTransformProvidersFound) {
            System.out.println("\nDid not find any registered transforms or SchemaTransforms.\n");
        }
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)port).addService((BindableService)service).addService((BindableService)new ArtifactRetrievalService());
        if (((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getAlsoStartLoopbackWorker()) {
            serverBuilder.addService((BindableService)new ExternalWorkerService(options));
        }
        Server server = serverBuilder.build();
        server.start();
        server.awaitTermination();
    }

    private static class NotRunnableRunner
    extends PipelineRunner<PipelineResult> {
        private NotRunnableRunner() {
        }

        public static @UnknownKeyFor @NonNull @Initialized NotRunnableRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions opts) {
            return new NotRunnableRunner();
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TransformProviderForBuilder
    implements TransformProvider {
        private final @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder transformBuilder;

        private TransformProviderForBuilder(@UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder transformBuilder) {
            this.transformBuilder = transformBuilder;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform getTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                Class configClass = ExpansionService.getConfigClass(this.transformBuilder);
                return this.transformBuilder.buildExternal(ExpansionService.payloadToConfig(ExternalTransforms.ExternalConfigurationPayload.parseFrom((ByteString)spec.getPayload()), configClass));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to build transform from spec %s", spec), e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDependencies(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                Class configClass = ExpansionService.getConfigClass(this.transformBuilder);
                Optional dependencies = this.transformBuilder.getDependencies(ExpansionService.payloadToConfig(ExternalTransforms.ExternalConfigurationPayload.parseFrom((ByteString)spec.getPayload()), configClass), options);
                return dependencies.orElseGet(() -> TransformProvider.super.getDependencies(spec, options));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to get dependencies for spec %s", spec), e);
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof TransformProviderForBuilder && Objects.equals(this.transformBuilder, ((TransformProviderForBuilder)other).transformBuilder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.transformBuilder.hashCode();
        }
    }

    private static class TransformProviderForPayloadTranslator<@UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
    implements TransformProvider<InputT, OutputT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator<@UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT>> payloadTranslator;

        private TransformProviderForPayloadTranslator(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator<@UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT>> payloadTranslator) {
            this.payloadTranslator = payloadTranslator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> getTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                ExternalTransforms.ExternalConfigurationPayload payload = ExternalTransforms.ExternalConfigurationPayload.parseFrom((ByteString)spec.getPayload());
                Row configRow = (Row)RowCoder.of((Schema)SchemaTranslation.schemaFromProto((SchemaApi.Schema)payload.getSchema())).decode((InputStream)new ByteArrayInputStream(payload.getPayload().toByteArray()));
                PTransform transformFromRow = this.payloadTranslator.fromConfigRow(configRow, options);
                if (transformFromRow != null) {
                    return transformFromRow;
                }
                throw new RuntimeException(String.format("A transform cannot be initiated using the provided config row %s and the TransformPayloadTranslator %s", configRow, this.payloadTranslator));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to build transform %s from spec %s", spec.getUrn(), spec), e);
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof TransformProviderForPayloadTranslator && Objects.equals(this.payloadTranslator, ((TransformProviderForPayloadTranslator)other).payloadTranslator);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.payloadTranslator.hashCode();
        }
    }

    @AutoService(value={ExpansionServiceRegistrar.class})
    public static class ExternalTransformRegistrarLoader
    implements ExpansionServiceRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformProvider> knownTransforms() {
            HashMap<String, TransformProvider> providers = new HashMap<String, TransformProvider>();
            Map<String, ExternalTransformBuilder> registeredBuilders = ExternalTransformRegistrarLoader.loadTransformBuilders();
            for (Map.Entry<String, ExternalTransformBuilder> registeredBuilder : registeredBuilders.entrySet()) {
                providers.put(registeredBuilder.getKey(), new TransformProviderForBuilder(registeredBuilder.getValue()));
            }
            ImmutableList deprecatedTransformURNs = ImmutableList.of((Object)"beam:transform:read:v1");
            Map registeredPayloadTranslators = PTransformTranslation.getKnownPayloadTranslators();
            for (Map.Entry entry : registeredPayloadTranslators.entrySet()) {
                String urn;
                PTransformTranslation.TransformPayloadTranslator translator;
                block5: {
                    translator = (PTransformTranslation.TransformPayloadTranslator)entry.getValue();
                    if (translator == null) continue;
                    try {
                        urn = translator.getUrn();
                        if (urn == null) {
                            LOG.debug("Could not load the TransformPayloadTranslator " + translator + " to the Expansion Service since it did not produce a unique URN.");
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        LOG.info("Could not load the TransformPayloadTranslator " + translator + " to the Expansion Service.", (Throwable)e);
                    }
                    continue;
                }
                if (deprecatedTransformURNs.contains(urn)) continue;
                String finalUrn = urn;
                TransformProviderForPayloadTranslator transformProvider = new TransformProviderForPayloadTranslator(translator);
                providers.put(finalUrn, transformProvider);
            }
            return providers;
        }

        private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder> loadTransformBuilders() {
            HashMap<String, ExternalTransformBuilder> registeredBuilders = new HashMap<String, ExternalTransformBuilder>();
            ImmutableSet.Builder conflictingRegistrations = new ImmutableSet.Builder();
            for (ExternalTransformRegistrar registrar : ServiceLoader.load(ExternalTransformRegistrar.class)) {
                for (Map.Entry entry : registrar.knownBuilderInstances().entrySet()) {
                    String urn = (String)entry.getKey();
                    ExternalTransformBuilder newBuilder = (ExternalTransformBuilder)entry.getValue();
                    @Nullable ExternalTransformBuilder existingBuilder = (ExternalTransformBuilder)registeredBuilders.get(urn);
                    if (existingBuilder == null) {
                        registeredBuilders.put(urn, newBuilder);
                        continue;
                    }
                    LOG.error("Conflicting registrations for {}: {} and {}", new Object[]{urn, existingBuilder, newBuilder});
                    conflictingRegistrations.add((Object)urn);
                }
            }
            ImmutableSet conflictingRegistrationSet = conflictingRegistrations.build();
            if (!conflictingRegistrationSet.isEmpty()) {
                throw new IllegalArgumentException(String.format("Conflicting registrations for: %s", Joiner.on((String)", ").join((Iterable)conflictingRegistrationSet)));
            }
            return registeredBuilders;
        }
    }

    public static interface ExpansionServiceRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformProvider> knownTransforms();
    }
}

