/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.util.Arrays;
import org.apache.beam.sdk.expansion.service.ExpansionServer;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;

public class ExpansionServerTest {
    @Test
    public void testStartupOnFreePort() throws Exception {
        try (ExpansionServer expansionServer = ExpansionServer.create((ExpansionService)new ExpansionService(), (String)"localhost", (int)0);){
            MatcherAssert.assertThat((Object)expansionServer.getHost(), (Matcher)Is.is((Object)"localhost"));
            MatcherAssert.assertThat((Object)expansionServer.getPort(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }

    @Test
    public void testHostPortAvailableAfterClose() throws Exception {
        ExpansionServer expansionServer;
        try (ExpansionServer expServer = ExpansionServer.create((ExpansionService)new ExpansionService(), (String)"localhost", (int)0);){
            expansionServer = expServer;
        }
        MatcherAssert.assertThat((Object)expansionServer.getHost(), (Matcher)Is.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)expansionServer.getPort(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testPassingPipelineArguments() {
        String[] args = new String[]{"--defaultEnvironmentType=PROCESS", "--defaultEnvironmentConfig={\"command\": \"/opt/apache/beam/boot\"}"};
        ExpansionService service = new ExpansionService(args);
        MatcherAssert.assertThat((Object)((PortablePipelineOptions)service.createPipeline(PipelineOptionsFactory.create()).getOptions().as(PortablePipelineOptions.class)).getDefaultEnvironmentType(), (Matcher)Matchers.equalTo((Object)"PROCESS"));
    }

    @Test
    public void testNonEmptyFilesToStage() {
        String[] args = new String[]{"--filesToStage=nonExistent1.jar,nonExistent2.jar"};
        ExpansionService service = new ExpansionService(args);
        MatcherAssert.assertThat((Object)((PortablePipelineOptions)service.createPipeline(PipelineOptionsFactory.create()).getOptions().as(PortablePipelineOptions.class)).getFilesToStage(), (Matcher)Matchers.equalTo(Arrays.asList("nonExistent1.jar", "nonExistent2.jar")));
    }

    @Test
    public void testEmptyFilesToStageIsOK() {
        String[] args = new String[]{"--filesToStage="};
        ExpansionService service = new ExpansionService(args);
        MatcherAssert.assertThat((Object)((PortablePipelineOptions)service.createPipeline(PipelineOptionsFactory.create()).getOptions().as(PortablePipelineOptions.class)).getFilesToStage(), (Matcher)Matchers.equalTo(Arrays.asList("")));
    }
}

