/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.expansion.service.Dependency;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.expansion.service.ExpansionServiceConfig;
import org.apache.beam.sdk.expansion.service.TransformProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Value;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Resources;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExpansionServiceTest {
    private static final String TEST_URN = "test:beam:transforms:count";
    private static final String TEST_OPTIONS_URN = "test:beam:transforms:test_options";
    private static final String TEST_NAME = "TestName";
    private static final String TEST_NAMESPACE = "namespace";
    private ExpansionService expansionService = new ExpansionService();
    public static final List<byte[]> BYTE_LIST = ImmutableList.of((Object)"testing", (Object)"compound", (Object)"coders").stream().map(str -> str.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList());
    public static final Map<String, Long> BYTE_KV_LIST = ImmutableList.of((Object)"testing", (Object)"compound", (Object)"coders").stream().collect(Collectors.toMap(str -> str, str -> str.length()));
    public static final Map<String, List<Long>> BYTE_KV_LIST_WITH_LIST_VALUE = ImmutableList.of((Object)"testing", (Object)"compound", (Object)"coders").stream().collect(Collectors.toMap(str -> str, str -> Collections.singletonList(Long.valueOf(str.length()))));

    @Test
    public void testConstruct() {
        Pipeline p = Pipeline.create();
        p.apply((PTransform)Impulse.create());
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        String inputPcollId = (String)Iterables.getOnlyElement(((RunnerApi.PTransform)Iterables.getOnlyElement(pipelineProto.getComponents().getTransformsMap().values())).getOutputsMap().values());
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(pipelineProto.getComponents()).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName(TEST_NAME).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(TEST_URN)).putInputs("input", inputPcollId)).setNamespace(TEST_NAMESPACE).build();
        ExpansionApi.ExpansionResponse response = this.expansionService.expand(request);
        RunnerApi.PTransform expandedTransform = response.getTransform();
        Assert.assertEquals((Object)"namespaceTestName", (Object)expandedTransform.getUniqueName());
        MatcherAssert.assertThat(expandedTransform.getInputsMap().values(), (Matcher)Matchers.contains((Object[])new String[]{inputPcollId}));
        MatcherAssert.assertThat(expandedTransform.getOutputsMap().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"output"}));
        MatcherAssert.assertThat((Object)expandedTransform.getSubtransformsCount(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (String subtransform : expandedTransform.getSubtransformsList()) {
            Assert.assertTrue((boolean)response.getComponents().containsTransforms(subtransform));
        }
        Set<String> originalIds = this.allIds(request.getComponents());
        for (String id : this.allIds(response.getComponents())) {
            Assert.assertTrue((String)id, (id.startsWith(TEST_NAMESPACE) || originalIds.contains(id) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConstructWithPipelineOptions() {
        PipelineOptionsFactory.register(TestOptions.class);
        Pipeline p = Pipeline.create();
        p.apply((PTransform)Impulse.create());
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        String inputPcollId = (String)Iterables.getOnlyElement(((RunnerApi.PTransform)Iterables.getOnlyElement(pipelineProto.getComponents().getTransformsMap().values())).getOutputsMap().values());
        Struct optionsStruct = Struct.newBuilder().putFields("beam:option:string_option:v1", Value.newBuilder().setStringValue("abcde").build()).putFields("beam:option:boolean_option:v1", Value.newBuilder().setBoolValue(TestTransformRegistrar.EXPECTED_BOOLEAN_VALUE.booleanValue()).build()).putFields("beam:option:integer_option:v1", Value.newBuilder().setNumberValue((double)TestTransformRegistrar.EXPECTED_INTEGER_VALUE.intValue()).build()).build();
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(pipelineProto.getComponents()).setPipelineOptions(optionsStruct).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName(TEST_NAME).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(TEST_OPTIONS_URN)).putInputs("input", inputPcollId)).setNamespace(TEST_NAMESPACE).build();
        ExpansionApi.ExpansionResponse response = this.expansionService.expand(request);
        RunnerApi.PTransform expandedTransform = response.getTransform();
        Assert.assertEquals((Object)"namespaceTestName", (Object)expandedTransform.getUniqueName());
        MatcherAssert.assertThat(expandedTransform.getInputsMap().values(), (Matcher)Matchers.contains((Object[])new String[]{inputPcollId}));
        MatcherAssert.assertThat(expandedTransform.getOutputsMap().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"output"}));
    }

    @Test
    public void testConstructGenerateSequenceWithRegistration() {
        ExternalTransforms.ExternalConfigurationPayload payload = ExpansionServiceTest.encodeRowIntoExternalConfigurationPayload(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"start", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.nullable((String)"stop", (Schema.FieldType)Schema.FieldType.INT64)})).withFieldValue("start", (Object)0L).withFieldValue("stop", (Object)1L).build());
        Pipeline p = Pipeline.create();
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(pipelineProto.getComponents()).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName(TEST_NAME).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:external:java:generate_sequence:v1").setPayload(payload.toByteString()))).setNamespace(TEST_NAMESPACE).build();
        ExpansionApi.ExpansionResponse response = this.expansionService.expand(request);
        RunnerApi.PTransform expandedTransform = response.getTransform();
        Assert.assertEquals((Object)"namespaceTestName", (Object)expandedTransform.getUniqueName());
        MatcherAssert.assertThat((Object)expandedTransform.getInputsCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)expandedTransform.getOutputsCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)expandedTransform.getSubtransformsCount(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testCompoundCodersForExternalConfiguration_setters() throws Exception {
        ExternalTransforms.ExternalConfigurationPayload externalConfig = ExpansionServiceTest.encodeRowIntoExternalConfigurationPayload(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.nullable((String)"config_key1", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.nullable((String)"config_key2", (Schema.FieldType)Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.BYTES)), Schema.Field.of((String)"config_key3", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.INT64)), Schema.Field.of((String)"config_key4", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)))})).withFieldValue("config_key1", (Object)1L).withFieldValue("config_key2", BYTE_LIST).withFieldValue("config_key3", BYTE_KV_LIST).withFieldValue("config_key4", BYTE_KV_LIST_WITH_LIST_VALUE).build());
        TestConfigSetters config = (TestConfigSetters)ExpansionService.payloadToConfig((ExternalTransforms.ExternalConfigurationPayload)externalConfig, TestConfigSetters.class);
        MatcherAssert.assertThat((Object)config.configKey1, (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)config.configKey2, (Matcher)Matchers.contains((Object[])BYTE_LIST.toArray()));
        MatcherAssert.assertThat((Object)config.configKey3, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        if (config.configKey3 != null) {
            MatcherAssert.assertThat(config.configKey3.entrySet(), (Matcher)Matchers.containsInAnyOrder((Collection)BYTE_KV_LIST.entrySet().stream().map(entry -> Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)((String)entry.getKey()))), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)((Long)entry.getValue()))))).collect(Collectors.toList())));
        }
        MatcherAssert.assertThat((Object)config.configKey4, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        if (config.configKey4 != null) {
            MatcherAssert.assertThat(config.configKey4.entrySet(), (Matcher)Matchers.containsInAnyOrder((Collection)BYTE_KV_LIST_WITH_LIST_VALUE.entrySet().stream().map(entry -> Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)((String)entry.getKey()))), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)((List)entry.getValue()))))).collect(Collectors.toList())));
        }
    }

    @Test
    public void testCompoundCodersForExternalConfiguration_schemas() throws Exception {
        ExternalTransforms.ExternalConfigurationPayload externalConfig = ExpansionServiceTest.encodeRowIntoExternalConfigurationPayload(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.nullable((String)"configKey1", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.nullable((String)"configKey2", (Schema.FieldType)Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.BYTES)), Schema.Field.of((String)"configKey3", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.INT64)), Schema.Field.of((String)"configKey4", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)))})).withFieldValue("configKey1", (Object)1L).withFieldValue("configKey2", BYTE_LIST).withFieldValue("configKey3", BYTE_KV_LIST).withFieldValue("configKey4", BYTE_KV_LIST_WITH_LIST_VALUE).build());
        TestConfigSchema config = (TestConfigSchema)ExpansionService.payloadToConfig((ExternalTransforms.ExternalConfigurationPayload)externalConfig, TestConfigSchema.class);
        MatcherAssert.assertThat((Object)config.getConfigKey1(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat(config.getConfigKey2(), (Matcher)Matchers.contains((Object[])BYTE_LIST.toArray()));
        Map<String, Long> configKey3 = config.getConfigKey3();
        MatcherAssert.assertThat(configKey3, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        if (configKey3 != null) {
            MatcherAssert.assertThat(configKey3.entrySet(), (Matcher)Matchers.containsInAnyOrder((Collection)BYTE_KV_LIST.entrySet().stream().map(entry -> Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)((String)entry.getKey()))), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)((Long)entry.getValue()))))).collect(Collectors.toList())));
        }
        Map<String, List<Long>> configKey4 = config.getConfigKey4();
        MatcherAssert.assertThat(configKey4, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        if (configKey4 != null) {
            MatcherAssert.assertThat(configKey4.entrySet(), (Matcher)Matchers.containsInAnyOrder((Collection)BYTE_KV_LIST_WITH_LIST_VALUE.entrySet().stream().map(entry -> Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)((String)entry.getKey()))), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)((List)entry.getValue()))))).collect(Collectors.toList())));
        }
    }

    @Test
    public void testExternalConfiguration_simpleSchema() throws Exception {
        ExternalTransforms.ExternalConfigurationPayload externalConfig = ExpansionServiceTest.encodeRowIntoExternalConfigurationPayload(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"bar", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"foo", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"list", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING))})).withFieldValue("foo", (Object)1L).withFieldValue("bar", (Object)"test string").withFieldValue("list", (Object)ImmutableList.of((Object)"abc", (Object)"123")).build());
        TestConfigSimpleSchema config = (TestConfigSimpleSchema)ExpansionService.payloadToConfig((ExternalTransforms.ExternalConfigurationPayload)externalConfig, TestConfigSimpleSchema.class);
        MatcherAssert.assertThat((Object)config.getFoo(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)config.getBar(), (Matcher)Matchers.is((Object)"test string"));
        MatcherAssert.assertThat(config.getList(), (Matcher)Matchers.is((Object)ImmutableList.of((Object)"abc", (Object)"123")));
    }

    @Test
    public void testExpansionServiceConfig() throws Exception {
        URL expansionServiceConfigFile = Resources.getResource((String)"./test_expansion_service_config.yaml");
        ExpansionServiceConfig config = ExpansionServiceConfig.parseFromYamlStream((InputStream)Files.newInputStream(Paths.get(expansionServiceConfigFile.getPath(), new String[0]), new OpenOption[0]));
        Assert.assertEquals((long)3L, (long)config.getAllowlist().size());
        Assert.assertTrue((boolean)config.getAllowlist().contains("beam:transform:my_dummy_transform_1"));
        Assert.assertTrue((boolean)config.getAllowlist().contains("beam:transform:my_dummy_transform_2"));
        Assert.assertTrue((boolean)config.getAllowlist().contains("beam:transform:my_dummy_transform_3"));
        Assert.assertEquals((long)2L, (long)config.getDependencies().size());
        Assert.assertTrue((boolean)config.getDependencies().containsKey("beam:transform:my_dummy_transform_2"));
        Assert.assertTrue((boolean)config.getDependencies().containsKey("beam:transform:my_dummy_transform_3"));
        Assert.assertEquals((long)1L, (long)((List)config.getDependencies().get("beam:transform:my_dummy_transform_2")).size());
        Assert.assertEquals((Object)"jars/my_dummy_transform_2_dep1.jar", (Object)((Dependency)((List)config.getDependencies().get("beam:transform:my_dummy_transform_2")).get(0)).getPath());
        Assert.assertEquals((long)2L, (long)((List)config.getDependencies().get("beam:transform:my_dummy_transform_3")).size());
        ArrayList<String> expectedDepsOfTransform3 = new ArrayList<String>(Arrays.asList("jars/my_dummy_transform_3_dep1.jar", "jars/my_dummy_transform_3_dep2.jar"));
        Assert.assertTrue((boolean)expectedDepsOfTransform3.contains(((Dependency)((List)config.getDependencies().get("beam:transform:my_dummy_transform_3")).get(0)).getPath()));
        Assert.assertTrue((boolean)expectedDepsOfTransform3.contains(((Dependency)((List)config.getDependencies().get("beam:transform:my_dummy_transform_3")).get(1)).getPath()));
    }

    private static ExternalTransforms.ExternalConfigurationPayload encodeRowIntoExternalConfigurationPayload(Row row) {
        ByteStringOutputStream outputStream = new ByteStringOutputStream();
        try {
            SchemaCoder.of((Schema)row.getSchema()).encode((Object)row, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ExternalTransforms.ExternalConfigurationPayload.newBuilder().setSchema(SchemaTranslation.schemaToProto((Schema)row.getSchema(), (boolean)true)).setPayload(outputStream.toByteString()).build();
    }

    public Set<String> allIds(RunnerApi.Components components) {
        HashSet<String> all = new HashSet<String>();
        all.addAll(components.getTransformsMap().keySet());
        all.addAll(components.getPcollectionsMap().keySet());
        all.addAll(components.getCodersMap().keySet());
        all.addAll(components.getWindowingStrategiesMap().keySet());
        all.addAll(components.getEnvironmentsMap().keySet());
        return all;
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    static abstract class TestConfigSimpleSchema {
        TestConfigSimpleSchema() {
        }

        abstract Long getFoo();

        abstract String getBar();

        abstract List<String> getList();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    static abstract class TestConfigSchema {
        TestConfigSchema() {
        }

        abstract @Nullable Long getConfigKey1();

        abstract @Nullable Iterable<byte[]> getConfigKey2();

        abstract @Nullable Map<String, Long> getConfigKey3();

        abstract @Nullable Map<String, List<Long>> getConfigKey4();
    }

    private static class TestConfigSetters {
        private @Nullable Long configKey1 = null;
        private @Nullable Iterable<byte[]> configKey2 = null;
        private @Nullable Map<byte[], Long> configKey3 = null;
        private @Nullable Map<byte[], List<Long>> configKey4 = null;

        private TestConfigSetters() {
        }

        public void setConfigKey1(@Nullable Long configKey1) {
            this.configKey1 = configKey1;
        }

        public void setConfigKey2(@Nullable Iterable<byte[]> configKey2) {
            this.configKey2 = configKey2;
        }

        public void setConfigKey3(@Nullable Map<byte[], Long> configKey3) {
            this.configKey3 = configKey3;
        }

        public void setConfigKey4(@Nullable Map<byte[], List<Long>> configKey4) {
            this.configKey4 = configKey4;
        }
    }

    public static class TestOptionsTransform
    extends PTransform<PCollection<String>, PCollection<String>> {
        String expectedStringValue;
        Boolean expectedBooleanValue;
        Integer expectedIntegerValue;

        public TestOptionsTransform(String expectedStringValue, Boolean expectedBooleanValue, Integer expectedIntegerValue) {
            this.expectedStringValue = expectedStringValue;
            this.expectedBooleanValue = expectedBooleanValue;
            this.expectedIntegerValue = expectedIntegerValue;
        }

        public PCollection<String> expand(PCollection<String> input) {
            TestOptions testOption = (TestOptions)input.getPipeline().getOptions().as(TestOptions.class);
            Assert.assertEquals((Object)this.expectedStringValue, (Object)testOption.getStringOption());
            Assert.assertEquals((Object)this.expectedBooleanValue, (Object)testOption.getBooleanOption());
            Assert.assertEquals((Object)this.expectedIntegerValue, (Object)testOption.getIntegerOption());
            return input;
        }
    }

    public static interface TestOptions
    extends PipelineOptions {
        public String getStringOption();

        public void setStringOption(String var1);

        public Boolean getBooleanOption();

        public void setBooleanOption(Boolean var1);

        public Integer getIntegerOption();

        public void setIntegerOption(Integer var1);
    }

    @AutoService(value={ExpansionService.ExpansionServiceRegistrar.class})
    public static class TestTransformRegistrar
    implements ExpansionService.ExpansionServiceRegistrar {
        static final String EXPECTED_STRING_VALUE = "abcde";
        static final Boolean EXPECTED_BOOLEAN_VALUE = true;
        static final Integer EXPECTED_INTEGER_VALUE = 12345;

        public Map<String, TransformProvider> knownTransforms() {
            return ImmutableMap.of((Object)ExpansionServiceTest.TEST_URN, (spec, options) -> Count.perElement(), (Object)ExpansionServiceTest.TEST_OPTIONS_URN, (spec, options) -> new TestOptionsTransform(EXPECTED_STRING_VALUE, EXPECTED_BOOLEAN_VALUE, EXPECTED_INTEGER_VALUE));
        }
    }
}

