/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.expansion.service.TransformProvider;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesJavaExpansionService;
import org.apache.beam.sdk.testing.UsesPythonExpansionService;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.construction.External;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ServerBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExternalTest
implements Serializable {
    @Rule
    public transient TestPipeline testPipeline = TestPipeline.create();
    private @MonotonicNonNull PipelineResult pipelineResult = null;
    private static final String TEST_URN_SIMPLE = "simple";
    private static final String TEST_URN_LE = "le";
    private static final String TEST_URN_MULTI = "multi";
    private static @MonotonicNonNull String localExpansionAddr = null;
    private static @MonotonicNonNull Server localExpansionServer = null;

    @BeforeClass
    public static void setUpClass() throws IOException {
        int localExpansionPort;
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            localExpansionPort = socket.getLocalPort();
        }
        localExpansionAddr = String.format("localhost:%s", localExpansionPort);
        localExpansionServer = ServerBuilder.forPort((int)localExpansionPort).addService((BindableService)new ExpansionService()).build();
        localExpansionServer.start();
    }

    @AfterClass
    @RequiresNonNull(value={"localExpansionServer"})
    public static void tearDownClass() {
        localExpansionServer.shutdownNow();
    }

    @After
    @RequiresNonNull(value={"pipelineResult"})
    public void tearDown() {
        this.pipelineResult.waitUntilFinish();
        MatcherAssert.assertThat((Object)this.pipelineResult.getState(), (Matcher)Matchers.equalTo((Object)PipelineResult.State.DONE));
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesJavaExpansionService.class, UsesPythonExpansionService.class})
    @RequiresNonNull(value={"localExpansionAddr"})
    public void expandSingleTest() {
        PCollection col = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)"1", (Object[])new String[]{"2", "3"}))).apply((PTransform)External.of((String)TEST_URN_SIMPLE, (byte[])new byte[0], (String)localExpansionAddr));
        PAssert.that((PCollection)col).containsInAnyOrder((Object[])new String[]{"11", "22", "33"});
        this.pipelineResult = this.testPipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesJavaExpansionService.class, UsesPythonExpansionService.class})
    @RequiresNonNull(value={"localExpansionAddr"})
    public void expandMultipleTest() {
        PCollection pcol = (PCollection)((PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6}))).apply("filter <=3", (PTransform)External.of((String)TEST_URN_LE, (byte[])"3".getBytes(StandardCharsets.UTF_8), (String)localExpansionAddr))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(Object::toString))).apply("put simple", (PTransform)External.of((String)TEST_URN_SIMPLE, (byte[])new byte[0], (String)localExpansionAddr));
        PAssert.that((PCollection)pcol).containsInAnyOrder((Object[])new String[]{"11", "22", "33"});
        this.pipelineResult = this.testPipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesJavaExpansionService.class, UsesPythonExpansionService.class})
    @RequiresNonNull(value={"localExpansionAddr"})
    public void expandMultiOutputTest() {
        PCollectionTuple pTuple = (PCollectionTuple)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6}))).apply((PTransform)External.of((String)TEST_URN_MULTI, (byte[])new byte[0], (String)localExpansionAddr).withMultiOutputs());
        PAssert.that((PCollection)pTuple.get((TupleTag)new TupleTag<Integer>("even"){})).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        PAssert.that((PCollection)pTuple.get((TupleTag)new TupleTag<Integer>("odd"){})).containsInAnyOrder((Object[])new Integer[]{1, 3, 5});
        this.pipelineResult = this.testPipeline.run();
    }

    @AutoService(value={ExpansionService.ExpansionServiceRegistrar.class})
    public static class TestTransforms
    implements ExpansionService.ExpansionServiceRegistrar,
    Serializable {
        private final TupleTag<Integer> even = new TupleTag<Integer>("even"){};
        private final TupleTag<Integer> odd = new TupleTag<Integer>("odd"){};

        public Map<String, TransformProvider> knownTransforms() {
            return ImmutableMap.of((Object)ExternalTest.TEST_URN_SIMPLE, (spec, options) -> MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x + x), (Object)ExternalTest.TEST_URN_LE, (spec, options) -> Filter.lessThanEq((Comparable)Integer.valueOf(Integer.parseInt(spec.getPayload().toStringUtf8()))), (Object)ExternalTest.TEST_URN_MULTI, (spec, options) -> ParDo.of((DoFn)new DoFn<Integer, Integer>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    if ((Integer)c.element() % 2 == 0) {
                        c.output((Object)((Integer)c.element()));
                    } else {
                        c.output(odd, (Object)((Integer)c.element()));
                    }
                }
            }).withOutputTags(this.even, TupleTagList.of(this.odd)));
        }
    }
}

