/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.expansion.service.ExpansionServiceOptions;
import org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProvider;
import org.apache.beam.sdk.expansion.service.MultiLanguageBuilderMethod;
import org.apache.beam.sdk.expansion.service.MultiLanguageConstructorMethod;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Resources;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JavaClassLookupTransformProviderTest {
    private static final String TEST_NAME = "TestName";
    private static final String TEST_NAMESPACE = "namespace";
    private static ExpansionService expansionService;

    @BeforeClass
    public static void setupExpansionService() {
        PipelineOptionsFactory.register(ExpansionServiceOptions.class);
        URL allowListFile = Resources.getResource((String)"./test_allowlist.yaml");
        expansionService = new ExpansionService(new String[]{"--javaClassLookupAllowlistFile=" + allowListFile.getPath()});
    }

    void testClassLookupExpansionRequestConstruction(ExternalTransforms.JavaClassLookupPayload payload, Map<String, Object> fieldsToVerify) {
        Pipeline p = Pipeline.create();
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(pipelineProto.getComponents()).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName(TEST_NAME).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.JAVA_CLASS_LOOKUP)).setPayload(payload.toByteString()))).setNamespace(TEST_NAMESPACE).build();
        ExpansionApi.ExpansionResponse response = expansionService.expand(request);
        RunnerApi.PTransform expandedTransform = response.getTransform();
        Assert.assertEquals((Object)"namespaceTestName", (Object)expandedTransform.getUniqueName());
        MatcherAssert.assertThat((Object)expandedTransform.getInputsCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)expandedTransform.getOutputsCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((long)2L, (long)expandedTransform.getSubtransformsCount());
        Assert.assertEquals((long)2L, (long)expandedTransform.getSubtransformsCount());
        MatcherAssert.assertThat((Object)expandedTransform.getSubtransforms(0), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"MyCreateTransform"), (Matcher)Matchers.containsString((String)"MyParDoTransform")));
        MatcherAssert.assertThat((Object)expandedTransform.getSubtransforms(1), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"MyCreateTransform"), (Matcher)Matchers.containsString((String)"MyParDoTransform")));
        RunnerApi.PTransform userParDoTransform = null;
        for (String transformId : response.getComponents().getTransformsMap().keySet()) {
            if (!transformId.contains("ParMultiDo-Dummy-")) continue;
            userParDoTransform = (RunnerApi.PTransform)response.getComponents().getTransformsMap().get(transformId);
        }
        Assert.assertNotNull(userParDoTransform);
        RunnerApi.ParDoPayload parDoPayload = null;
        try {
            parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)userParDoTransform.getSpec().getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)parDoPayload);
        DummyDoFn doFn = (DummyDoFn)ParDoTranslation.doFnWithExecutionInformationFromProto((RunnerApi.FunctionSpec)parDoPayload.getDoFn()).getDoFn();
        System.out.println("DoFn" + (Object)((Object)doFn));
        ArrayList<String> verifiedFields = new ArrayList<String>();
        if (fieldsToVerify.keySet().contains("strField1")) {
            Assert.assertEquals((Object)doFn.strField1, (Object)fieldsToVerify.get("strField1"));
            verifiedFields.add("strField1");
        }
        if (fieldsToVerify.keySet().contains("strField2")) {
            Assert.assertEquals((Object)doFn.strField2, (Object)fieldsToVerify.get("strField2"));
            verifiedFields.add("strField2");
        }
        if (fieldsToVerify.keySet().contains("intField1")) {
            Assert.assertEquals((Object)doFn.intField1, (Object)fieldsToVerify.get("intField1"));
            verifiedFields.add("intField1");
        }
        if (fieldsToVerify.keySet().contains("doubleWrapperField")) {
            Assert.assertEquals((Object)doFn.doubleWrapperField, (Object)fieldsToVerify.get("doubleWrapperField"));
            verifiedFields.add("doubleWrapperField");
        }
        if (fieldsToVerify.containsKey("complexTypeStrField")) {
            Assert.assertEquals((Object)doFn.complexTypeField.complexTypeStrField, (Object)fieldsToVerify.get("complexTypeStrField"));
            verifiedFields.add("complexTypeStrField");
        }
        if (fieldsToVerify.containsKey("complexTypeIntField")) {
            Assert.assertEquals((Object)doFn.complexTypeField.complexTypeIntField, (Object)fieldsToVerify.get("complexTypeIntField"));
            verifiedFields.add("complexTypeIntField");
        }
        if (fieldsToVerify.keySet().contains("strArrayField")) {
            Assert.assertArrayEquals((Object[])doFn.strArrayField, (Object[])((String[])fieldsToVerify.get("strArrayField")));
            verifiedFields.add("strArrayField");
        }
        if (fieldsToVerify.keySet().contains("strListField")) {
            Assert.assertEquals(doFn.strListField, (Object)((List)fieldsToVerify.get("strListField")));
            verifiedFields.add("strListField");
        }
        if (fieldsToVerify.keySet().contains("complexTypeArrayField")) {
            Assert.assertArrayEquals((Object[])doFn.complexTypeArrayField, (Object[])((DummyComplexType[])fieldsToVerify.get("complexTypeArrayField")));
            verifiedFields.add("complexTypeArrayField");
        }
        if (fieldsToVerify.keySet().contains("complexTypeListField")) {
            Assert.assertEquals(doFn.complexTypeListField, (Object)((List)fieldsToVerify.get("complexTypeListField")));
            verifiedFields.add("complexTypeListField");
        }
        ArrayList<String> unverifiedFields = new ArrayList<String>(fieldsToVerify.keySet());
        unverifiedFields.removeAll(verifiedFields);
        if (!unverifiedFields.isEmpty()) {
            throw new RuntimeException("Failed to verify some fields: " + unverifiedFields);
        }
    }

    @Test
    public void testJavaClassLookupWithConstructor() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructor");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1"));
    }

    @Test
    public void testJavaClassLookupWithConstructorMethod() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorMethod");
        payloadBuilder.setConstructorMethod("from");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1"));
    }

    @Test
    public void testJavaClassLookupWithConstructorAndBuilderMethods() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorAndBuilderMethods");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrField2");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField2", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withIntField1");
        builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"intField1", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("intField1", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupRespectsIgnoreFields() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorAndBuilderMethods");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ignore123", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("ignore123", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrField2");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ignore456", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("ignore456", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withIntField1");
        builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ignore789", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("ignore789", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupWithMultiArgumentConstructor() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithMultiArgumentConstructor");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").withFieldValue("strField2", (Object)"test_str_2").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2"));
    }

    @Test
    public void testJavaClassLookupWithMultiArgumentBuilderMethod() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithMultiArgumentBuilderMethod");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withFields");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"intField1", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("strField2", (Object)"test_str_2").withFieldValue("intField1", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupWithWrapperTypes() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithWrapperTypes");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withDoubleWrapperField");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"doubleWrapperField", (Schema.FieldType)Schema.FieldType.DOUBLE)})).withFieldValue("doubleWrapperField", (Object)123.56).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"doubleWrapperField", (Object)123.56));
    }

    @Test
    public void testJavaClassLookupWithComplexTypes() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithComplexTypes");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        Schema complexTypeSchema = Schema.builder().addStringField("complexTypeStrField").addInt32Field("complexTypeIntField").build();
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withComplexTypeField");
        Row builderMethodParamRow = Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_1").withFieldValue("complexTypeIntField", (Object)123).build();
        Schema builderMethodSchema = Schema.builder().addRowField("complexTypeField", complexTypeSchema).build();
        Row builderMethodRow = Row.withSchema((Schema)builderMethodSchema).withFieldValue("complexTypeField", (Object)builderMethodParamRow).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"complexTypeStrField", (Object)"complex_type_str_1", (Object)"complexTypeIntField", (Object)123));
    }

    @Test
    public void testJavaClassLookupWithSimpleArrayType() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithArray");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrArrayField");
        Schema builderMethodSchema = Schema.builder().addArrayField("strArrayField", Schema.FieldType.STRING).build();
        Row builderMethodRow = Row.withSchema((Schema)builderMethodSchema).withFieldValue("strArrayField", (Object)ImmutableList.of((Object)"test_str_1", (Object)"test_str_2", (Object)"test_str_3")).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        String[] resultArray = new String[]{"test_str_1", "test_str_2", "test_str_3"};
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strArrayField", (Object)resultArray));
    }

    @Test
    public void testJavaClassLookupWithSimpleListType() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithList");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrListField");
        Schema builderMethodSchema = Schema.builder().addIterableField("strListField", Schema.FieldType.STRING).build();
        Row builderMethodRow = Row.withSchema((Schema)builderMethodSchema).withFieldValue("strListField", (Object)ImmutableList.of((Object)"test_str_1", (Object)"test_str_2", (Object)"test_str_3")).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add("test_str_1");
        resultList.add("test_str_2");
        resultList.add("test_str_3");
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strListField", resultList));
    }

    @Test
    public void testJavaClassLookupWithComplexArrayType() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithComplexTypeArray");
        Schema complexTypeSchema = Schema.builder().addStringField("complexTypeStrField").addInt32Field("complexTypeIntField").build();
        Schema builderMethodSchema = Schema.builder().addArrayField("complexTypeArrayField", Schema.FieldType.row((Schema)complexTypeSchema)).build();
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ArrayList<Row> complexTypeList = new ArrayList<Row>();
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_1").withFieldValue("complexTypeIntField", (Object)123).build());
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_2").withFieldValue("complexTypeIntField", (Object)456).build());
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_3").withFieldValue("complexTypeIntField", (Object)789).build());
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withComplexTypeArrayField");
        Row builderMethodRow = Row.withSchema((Schema)builderMethodSchema).withFieldValue("complexTypeArrayField", complexTypeList).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        ArrayList<DummyComplexType> resultList = new ArrayList<DummyComplexType>();
        resultList.add(new DummyComplexType("complex_type_str_1", 123));
        resultList.add(new DummyComplexType("complex_type_str_2", 456));
        resultList.add(new DummyComplexType("complex_type_str_3", 789));
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"complexTypeArrayField", (Object)resultList.toArray(new DummyComplexType[0])));
    }

    @Test
    public void testJavaClassLookupWithComplexListType() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithComplexTypeList");
        Schema complexTypeSchema = Schema.builder().addStringField("complexTypeStrField").addInt32Field("complexTypeIntField").build();
        Schema builderMethodSchema = Schema.builder().addIterableField("complexTypeListField", Schema.FieldType.row((Schema)complexTypeSchema)).build();
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ArrayList<Row> complexTypeList = new ArrayList<Row>();
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_1").withFieldValue("complexTypeIntField", (Object)123).build());
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_2").withFieldValue("complexTypeIntField", (Object)456).build());
        complexTypeList.add(Row.withSchema((Schema)complexTypeSchema).withFieldValue("complexTypeStrField", (Object)"complex_type_str_3").withFieldValue("complexTypeIntField", (Object)789).build());
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withComplexTypeListField");
        Row builderMethodRow = Row.withSchema((Schema)builderMethodSchema).withFieldValue("complexTypeListField", complexTypeList).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        ArrayList<DummyComplexType> resultList = new ArrayList<DummyComplexType>();
        resultList.add(new DummyComplexType("complex_type_str_1", 123));
        resultList.add(new DummyComplexType("complex_type_str_2", 456));
        resultList.add(new DummyComplexType("complex_type_str_3", 789));
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"complexTypeListField", resultList));
    }

    @Test
    public void testJavaClassLookupWithConstructorMethodAndBuilderMethods() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorMethodAndBuilderMethods");
        payloadBuilder.setConstructorMethod("from");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrField2");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField2", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withIntField1");
        builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"intField1", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("intField1", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupWithSimplifiedBuilderMethodNames() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorMethodAndBuilderMethods");
        payloadBuilder.setConstructorMethod("from");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("strField2");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField2", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("intField1");
        builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"intField1", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("intField1", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupWithAnnotations() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithMultiLanguageAnnotations");
        payloadBuilder.setConstructorMethod("create_transform");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("abc");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField2", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField2", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("xyz");
        builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"intField1", (Schema.FieldType)Schema.FieldType.INT32)})).withFieldValue("intField1", (Object)10).build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of((Object)"strField1", (Object)"test_str_1", (Object)"strField2", (Object)"test_str_2", (Object)"intField1", (Object)10));
    }

    @Test
    public void testJavaClassLookupClassNotAvailable() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$UnavailableClass");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of()));
        Assert.assertTrue((boolean)thrown.getMessage().contains("does not enable"));
    }

    @Test
    public void testJavaClassLookupIncorrectConstructionParameter() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructor");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"incorrectField", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("incorrectField", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of()));
        Assert.assertTrue((boolean)thrown.getMessage().contains("Could not find a matching constructor"));
    }

    @Test
    public void testJavaClassLookupIncorrectBuilderMethodParameter() {
        ExternalTransforms.JavaClassLookupPayload.Builder payloadBuilder = ExternalTransforms.JavaClassLookupPayload.newBuilder();
        payloadBuilder.setClassName("org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProviderTest$DummyTransformWithConstructorAndBuilderMethods");
        Row constructorRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"strField1", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("strField1", (Object)"test_str_1").build();
        payloadBuilder.setConstructorSchema(this.getProtoSchemaFromRow(constructorRow));
        payloadBuilder.setConstructorPayload(this.getProtoPayloadFromRow(constructorRow));
        ExternalTransforms.BuilderMethod.Builder builderMethodBuilder = ExternalTransforms.BuilderMethod.newBuilder();
        builderMethodBuilder.setName("withStrField2");
        Row builderMethodRow = Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"incorrectParam", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("incorrectParam", (Object)"test_str_2").build();
        builderMethodBuilder.setSchema(this.getProtoSchemaFromRow(builderMethodRow));
        builderMethodBuilder.setPayload(this.getProtoPayloadFromRow(builderMethodRow));
        payloadBuilder.addBuilderMethods(builderMethodBuilder);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.testClassLookupExpansionRequestConstruction(payloadBuilder.build(), (Map<String, Object>)ImmutableMap.of()));
        Assert.assertTrue((boolean)thrown.getMessage().contains("Could not find a matching method"));
    }

    private SchemaApi.Schema getProtoSchemaFromRow(Row row) {
        return SchemaTranslation.schemaToProto((Schema)row.getSchema(), (boolean)true);
    }

    private ByteString getProtoPayloadFromRow(Row row) {
        ByteStringOutputStream outputStream = new ByteStringOutputStream();
        try {
            SchemaCoder.of((Schema)row.getSchema()).encode((Object)row, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.toByteString();
    }

    @Test
    public void testNothingAllowList() {
        JavaClassLookupTransformProvider.AllowList nothing = JavaClassLookupTransformProvider.AllowList.nothing();
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> nothing.getAllowedClass("org.apache.beam.sdk.transforms.KvSwap"));
        Assert.assertTrue((String)thrown.getMessage(), (boolean)thrown.getMessage().contains("allow list does not enable"));
        Assert.assertTrue((String)thrown.getMessage(), (boolean)thrown.getMessage().contains("org.apache.beam.sdk.transforms.KvSwap"));
    }

    @Test
    public void testEverythingAllowList() {
        JavaClassLookupTransformProvider.AllowList everything = JavaClassLookupTransformProvider.AllowList.everything();
        JavaClassLookupTransformProvider.AllowedClass allowedClass = everything.getAllowedClass("org.apache.beam.sdk.transforms.KvSwap");
        Assert.assertTrue((boolean)allowedClass.isAllowedBuilderMethod("builder"));
        Assert.assertTrue((boolean)allowedClass.isAllowedConstructorMethod("constructor"));
    }

    @Test
    public void testPackageAllowList() {
        JavaClassLookupTransformProvider.AllowList allowList = JavaClassLookupTransformProvider.AllowList.create((String)"v1", Collections.singletonList(JavaClassLookupTransformProvider.AllowedClass.create((String)"good.package.*", Collections.singletonList("goodBuilder"), (List)JavaClassLookupTransformProvider.AllowedClass.WILDCARD)));
        Assert.assertThrows(RuntimeException.class, () -> allowList.getAllowedClass("bad.package.Transform"));
        JavaClassLookupTransformProvider.AllowedClass allowedClass = allowList.getAllowedClass("good.package.Transform");
        Assert.assertTrue((boolean)allowedClass.isAllowedBuilderMethod("goodBuilder"));
        Assert.assertFalse((boolean)allowedClass.isAllowedBuilderMethod("badBuilder"));
        Assert.assertTrue((boolean)allowedClass.isAllowedConstructorMethod("anyConstructor"));
    }

    public static class DummyTransformWithComplexTypeList
    extends DummyTransform {
        public DummyTransformWithComplexTypeList(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithComplexTypeList withComplexTypeListField(List<DummyComplexType> complexTypeListField) {
            this.complexTypeListField = complexTypeListField;
            return this;
        }
    }

    public static class DummyTransformWithComplexTypeArray
    extends DummyTransform {
        public DummyTransformWithComplexTypeArray(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithComplexTypeArray withComplexTypeArrayField(DummyComplexType[] complexTypeArrayField) {
            this.complexTypeArrayField = complexTypeArrayField;
            return this;
        }
    }

    public static class DummyTransformWithList
    extends DummyTransform {
        public DummyTransformWithList(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithList withStrListField(List<String> strListField) {
            this.strListField = strListField;
            return this;
        }
    }

    public static class DummyTransformWithArray
    extends DummyTransform {
        public DummyTransformWithArray(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithArray withStrArrayField(String[] strArrayField) {
            this.strArrayField = strArrayField;
            return this;
        }
    }

    public static class DummyTransformWithComplexTypes
    extends DummyTransform {
        public DummyTransformWithComplexTypes(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithComplexTypes withComplexTypeField(DummyComplexType complexTypeField) {
            this.complexTypeField = complexTypeField;
            return this;
        }
    }

    public static class DummyTransformWithWrapperTypes
    extends DummyTransform {
        public DummyTransformWithWrapperTypes(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithWrapperTypes withDoubleWrapperField(Double doubleWrapperField) {
            this.doubleWrapperField = doubleWrapperField;
            return this;
        }
    }

    public static class DummyTransformWithMultiLanguageAnnotations
    extends DummyTransform {
        @MultiLanguageConstructorMethod(name="create_transform")
        public static DummyTransformWithMultiLanguageAnnotations from(String strField1) {
            DummyTransformWithMultiLanguageAnnotations transform = new DummyTransformWithMultiLanguageAnnotations();
            transform.strField1 = strField1;
            return transform;
        }

        @MultiLanguageBuilderMethod(name="abc")
        public DummyTransformWithMultiLanguageAnnotations withStrField2(String strField2) {
            this.strField2 = strField2;
            return this;
        }

        @MultiLanguageBuilderMethod(name="xyz")
        public DummyTransformWithMultiLanguageAnnotations withIntField1(int intField1) {
            this.intField1 = intField1;
            return this;
        }
    }

    public static class DummyTransformWithConstructorMethodAndBuilderMethods
    extends DummyTransform {
        public static DummyTransformWithConstructorMethodAndBuilderMethods from(String strField1) {
            DummyTransformWithConstructorMethodAndBuilderMethods transform = new DummyTransformWithConstructorMethodAndBuilderMethods();
            transform.strField1 = strField1;
            return transform;
        }

        public DummyTransformWithConstructorMethodAndBuilderMethods withStrField2(String strField2) {
            this.strField2 = strField2;
            return this;
        }

        public DummyTransformWithConstructorMethodAndBuilderMethods withIntField1(int intField1) {
            this.intField1 = intField1;
            return this;
        }
    }

    public static class DummyTransformWithConstructorMethod
    extends DummyTransform {
        public static DummyTransformWithConstructorMethod from(String strField1) {
            DummyTransformWithConstructorMethod transform = new DummyTransformWithConstructorMethod();
            transform.strField1 = strField1;
            return transform;
        }
    }

    public static class DummyTransformWithMultiArgumentConstructor
    extends DummyTransform {
        public DummyTransformWithMultiArgumentConstructor(String strField1, String strField2) {
            this.strField1 = strField1;
            this.strField2 = strField2;
        }
    }

    public static class DummyTransformWithMultiArgumentBuilderMethod
    extends DummyTransform {
        public DummyTransformWithMultiArgumentBuilderMethod(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithMultiArgumentBuilderMethod withFields(String strField2, int intField1) {
            this.strField2 = strField2;
            this.intField1 = intField1;
            return this;
        }
    }

    public static class DummyTransformWithConstructorAndBuilderMethods
    extends DummyTransform {
        public DummyTransformWithConstructorAndBuilderMethods(String strField1) {
            this.strField1 = strField1;
        }

        public DummyTransformWithConstructorAndBuilderMethods withStrField2(String strField2) {
            this.strField2 = strField2;
            return this;
        }

        public DummyTransformWithConstructorAndBuilderMethods withIntField1(int intField1) {
            this.intField1 = intField1;
            return this;
        }
    }

    public static class DummyTransformWithConstructor
    extends DummyTransform {
        public DummyTransformWithConstructor(String strField1) {
            this.strField1 = strField1;
        }
    }

    public static class DummyTransform
    extends PTransform<PBegin, PCollection<String>> {
        String strField1;
        String strField2;
        int intField1;
        Double doubleWrapperField;
        String[] strArrayField;
        DummyComplexType complexTypeField;
        DummyComplexType[] complexTypeArrayField;
        List<String> strListField;
        List<DummyComplexType> complexTypeListField;

        public PCollection<String> expand(PBegin input) {
            return (PCollection)((PCollection)input.apply("MyCreateTransform", (PTransform)Create.of((Object)"aaa", (Object[])new String[]{"bbb", "ccc"}))).apply("MyParDoTransform", (PTransform)ParDo.of((DoFn)new DummyDoFn(this.strField1, this.strField2, this.intField1, this.doubleWrapperField, this.strArrayField, this.complexTypeField, this.complexTypeArrayField, this.strListField, this.complexTypeListField)));
        }
    }

    public static class DummyComplexType
    implements Serializable {
        String complexTypeStrField;
        int complexTypeIntField;

        public DummyComplexType() {
        }

        public DummyComplexType(String complexTypeStrField, int complexTypeIntField) {
            this.complexTypeStrField = complexTypeStrField;
            this.complexTypeIntField = complexTypeIntField;
        }

        public int hashCode() {
            return this.complexTypeStrField.hashCode() + this.complexTypeIntField * 31;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DummyComplexType)) {
                return false;
            }
            DummyComplexType toCompare = (DummyComplexType)obj;
            return this.complexTypeIntField == toCompare.complexTypeIntField && this.complexTypeStrField.equals(toCompare.complexTypeStrField);
        }
    }

    static class DummyDoFn
    extends DoFn<String, String> {
        String strField1;
        String strField2;
        int intField1;
        Double doubleWrapperField;
        String[] strArrayField;
        DummyComplexType complexTypeField;
        DummyComplexType[] complexTypeArrayField;
        List<String> strListField;
        List<DummyComplexType> complexTypeListField;

        private DummyDoFn(String strField1, String strField2, int intField1, Double doubleWrapperField, String[] strArrayField, DummyComplexType complexTypeField, DummyComplexType[] complexTypeArrayField, List<String> strListField, List<DummyComplexType> complexTypeListField) {
            this.intField1 = intField1;
            this.strField1 = strField1;
            this.strField2 = strField2;
            this.doubleWrapperField = doubleWrapperField;
            this.strArrayField = strArrayField;
            this.complexTypeField = complexTypeField;
            this.complexTypeArrayField = complexTypeArrayField;
            this.strListField = strListField;
            this.complexTypeListField = complexTypeListField;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((String)c.element()));
        }
    }
}

