/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.arrow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ArrowConversion {
    private static Schema.Field toBeamField(Field field) {
        Schema.FieldType beamFieldType = ArrowConversion.toFieldType(field.getFieldType(), field.getChildren());
        return Schema.Field.of((String)field.getName(), (Schema.FieldType)beamFieldType);
    }

    private static Schema.FieldType toFieldType(FieldType arrowFieldType, final List<Field> childrenFields) {
        Schema.FieldType fieldType = (Schema.FieldType)arrowFieldType.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<Schema.FieldType>(){

            public Schema.FieldType visit(ArrowType.Null type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Struct type) {
                return Schema.FieldType.row((Schema)ArrowSchemaTranslator.toBeamSchema(childrenFields));
            }

            public Schema.FieldType visit(ArrowType.List type) {
                Preconditions.checkArgument((childrenFields.size() == 1 ? 1 : 0) != 0, (Object)("Encountered " + childrenFields.size() + " child fields for list type, expected 1"));
                return Schema.FieldType.array((Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(0)).getType());
            }

            public Schema.FieldType visit(ArrowType.FixedSizeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Union type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Map type) {
                Preconditions.checkArgument((childrenFields.size() == 2 ? 1 : 0) != 0, (Object)("Encountered " + childrenFields.size() + " child fields for map type, expected 2"));
                return Schema.FieldType.map((Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(0)).getType(), (Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(1)).getType());
            }

            public Schema.FieldType visit(ArrowType.Int type) {
                if (!type.getIsSigned()) {
                    throw new IllegalArgumentException("Unsigned integers are not supported.");
                }
                switch (type.getBitWidth()) {
                    case 8: {
                        return Schema.FieldType.BYTE;
                    }
                    case 16: {
                        return Schema.FieldType.INT16;
                    }
                    case 32: {
                        return Schema.FieldType.INT32;
                    }
                    case 64: {
                        return Schema.FieldType.INT64;
                    }
                }
                throw new IllegalArgumentException("Unsupported integer bit width: " + type.getBitWidth());
            }

            public Schema.FieldType visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case SINGLE: {
                        return Schema.FieldType.FLOAT;
                    }
                    case DOUBLE: {
                        return Schema.FieldType.DOUBLE;
                    }
                }
                throw new IllegalArgumentException("Unsupported floating-point precision: " + type.getPrecision().name());
            }

            public Schema.FieldType visit(ArrowType.Utf8 type) {
                return Schema.FieldType.STRING;
            }

            public Schema.FieldType visit(ArrowType.Binary type) {
                return Schema.FieldType.BYTES;
            }

            public Schema.FieldType visit(ArrowType.FixedSizeBinary type) {
                return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)type.getByteWidth()));
            }

            public Schema.FieldType visit(ArrowType.Bool type) {
                return Schema.FieldType.BOOLEAN;
            }

            public Schema.FieldType visit(ArrowType.Decimal type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Date type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Time type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Timestamp type) {
                if (type.getUnit() == TimeUnit.MILLISECOND || type.getUnit() == TimeUnit.MICROSECOND) {
                    return Schema.FieldType.DATETIME;
                }
                throw new IllegalArgumentException("Unsupported timestamp unit: " + type.getUnit().name());
            }

            public Schema.FieldType visit(ArrowType.Interval type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.Duration type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.LargeBinary type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.LargeUtf8 type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Schema.FieldType visit(ArrowType.LargeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }
        });
        return fieldType.withNullable(arrowFieldType.isNullable());
    }

    public static RecordBatchRowIterator rowsFromRecordBatch(Schema schema, VectorSchemaRoot vectorSchemaRoot) {
        return new RecordBatchRowIterator(schema, vectorSchemaRoot);
    }

    public static RecordBatchRowIterator rowsFromSerializedRecordBatch(org.apache.arrow.vector.types.pojo.Schema arrowSchema, InputStream inputStream, RootAllocator allocator) throws IOException {
        VectorSchemaRoot vectorRoot = VectorSchemaRoot.create((org.apache.arrow.vector.types.pojo.Schema)arrowSchema, (BufferAllocator)allocator);
        VectorLoader vectorLoader = new VectorLoader(vectorRoot);
        vectorRoot.clear();
        try (ReadChannel read = new ReadChannel(Channels.newChannel(inputStream));
             ArrowRecordBatch arrowMessage = MessageSerializer.deserializeRecordBatch((ReadChannel)read, (BufferAllocator)allocator);){
            vectorLoader.load(arrowMessage);
        }
        return ArrowConversion.rowsFromRecordBatch(ArrowSchemaTranslator.toBeamSchema(arrowSchema), vectorRoot);
    }

    public static org.apache.arrow.vector.types.pojo.Schema arrowSchemaFromInput(InputStream input) throws IOException {
        ReadChannel readChannel = new ReadChannel(Channels.newChannel(input));
        return MessageSerializer.deserializeSchema((ReadChannel)readChannel);
    }

    private ArrowConversion() {
    }

    public static class ArrowSchemaTranslator {
        public static Schema toBeamSchema(org.apache.arrow.vector.types.pojo.Schema schema) {
            return ArrowSchemaTranslator.toBeamSchema(schema.getFields());
        }

        public static Schema toBeamSchema(List<Field> fields) {
            Schema.Builder builder = Schema.builder();
            for (Field field : fields) {
                Schema.Field beamField = ArrowConversion.toBeamField(field);
                builder.addField(beamField);
            }
            return builder.build();
        }
    }

    public static class RecordBatchRowIterator
    implements Iterator<Row>,
    AutoCloseable {
        private static final ArrowValueConverterVisitor valueConverterVisitor = new ArrowValueConverterVisitor();
        private final Schema schema;
        private final VectorSchemaRoot vectorSchemaRoot;
        private final Factory<List<FieldValueGetter>> fieldValueGetters;
        private Integer currRowIndex;

        private RecordBatchRowIterator(Schema schema, VectorSchemaRoot vectorSchemaRoot) {
            this.schema = schema;
            this.vectorSchemaRoot = vectorSchemaRoot;
            this.fieldValueGetters = new CachingFactory((Factory)FieldVectorListValueGetterFactory.of(vectorSchemaRoot.getFieldVectors()));
            this.currRowIndex = 0;
        }

        @Override
        public void close() {
            this.vectorSchemaRoot.close();
        }

        @Override
        public boolean hasNext() {
            return this.currRowIndex < this.vectorSchemaRoot.getRowCount();
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("There are no more Rows.");
            }
            Row result = Row.withSchema((Schema)this.schema).withFieldValueGetters(this.fieldValueGetters, (Object)this.currRowIndex);
            this.currRowIndex = this.currRowIndex + 1;
            return result;
        }

        private static class ArrowValueConverterVisitor
        implements ArrowType.ArrowTypeVisitor<Optional<Function<Object, Object>>> {
            private ArrowValueConverterVisitor() {
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Null type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Struct type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.List type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.FixedSizeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Union type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Map type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Duration type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Int type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.FloatingPoint type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Utf8 type) {
                return Optional.of(text -> ((Text)text).toString());
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Binary type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.FixedSizeBinary type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Bool type) {
                return Optional.empty();
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Decimal type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Date type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Time type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Timestamp type) {
                DateTimeZone tz;
                try {
                    tz = DateTimeZone.forID((String)type.getTimezone());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Encountered unrecognized Timezone: " + type.getTimezone());
                }
                switch (type.getUnit()) {
                    case MICROSECOND: {
                        return Optional.of(epochMicros -> new DateTime((Long)epochMicros / 1000L, tz));
                    }
                    case MILLISECOND: {
                        return Optional.of(epochMills -> new DateTime(((Long)epochMills).longValue(), tz));
                    }
                }
                throw new AssertionError((Object)("Encountered unrecognized TimeUnit: " + type.getUnit()));
            }

            public Optional<Function<Object, Object>> visit(ArrowType.Interval type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.LargeBinary type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.LargeUtf8 type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public Optional<Function<Object, Object>> visit(ArrowType.LargeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }
        }

        private static class FieldVectorListValueGetterFactory
        implements Factory<List<FieldValueGetter>> {
            private final List<FieldVector> fieldVectors;

            static FieldVectorListValueGetterFactory of(List<FieldVector> fieldVectors) {
                return new FieldVectorListValueGetterFactory(fieldVectors);
            }

            private FieldVectorListValueGetterFactory(List<FieldVector> fieldVectors) {
                this.fieldVectors = fieldVectors;
            }

            public List<FieldValueGetter> create(Class<?> clazz, Schema schema) {
                return this.fieldVectors.stream().map(fieldVector -> {
                    Optional optionalValue = (Optional)fieldVector.getField().getFieldType().getType().accept((ArrowType.ArrowTypeVisitor)valueConverterVisitor);
                    if (!optionalValue.isPresent()) {
                        return new FieldValueGetter<Integer, Object>(){

                            @Nullable
                            public Object get(Integer rowIndex) {
                                return fieldVector.getObject(rowIndex.intValue());
                            }

                            public String name() {
                                return fieldVector.getField().getName();
                            }
                        };
                    }
                    final Function conversionFunction = (Function)optionalValue.get();
                    return new FieldValueGetter<Integer, Object>(){

                        @Nullable
                        public Object get(Integer rowIndex) {
                            Object value = fieldVector.getObject(rowIndex.intValue());
                            if (value == null) {
                                return null;
                            }
                            return conversionFunction.apply(value);
                        }

                        public String name() {
                            return fieldVector.getField().getName();
                        }
                    };
                }).collect(Collectors.toList());
            }
        }
    }
}

