/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.arrow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ArrowConversion {
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field toBeamField(@UnknownKeyFor @NonNull @Initialized Field field) {
        Schema.FieldType beamFieldType = ArrowConversion.toFieldType(field.getFieldType(), field.getChildren());
        return Schema.Field.of((String)field.getName(), (Schema.FieldType)beamFieldType);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType toFieldType(@UnknownKeyFor @NonNull @Initialized FieldType arrowFieldType, final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> childrenFields) {
        Schema.FieldType fieldType = (Schema.FieldType)arrowFieldType.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<Schema.FieldType>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Null type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Struct type) {
                return Schema.FieldType.row((Schema)ArrowSchemaTranslator.toBeamSchema(childrenFields));
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.List type) {
                Preconditions.checkArgument((childrenFields.size() == 1 ? 1 : 0) != 0, (Object)("Encountered " + childrenFields.size() + " child fields for list type, expected 1"));
                return Schema.FieldType.array((Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(0)).getType());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FixedSizeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Union type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Map type) {
                Preconditions.checkArgument((childrenFields.size() == 2 ? 1 : 0) != 0, (Object)("Encountered " + childrenFields.size() + " child fields for map type, expected 2"));
                return Schema.FieldType.map((Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(0)).getType(), (Schema.FieldType)ArrowConversion.toBeamField((Field)childrenFields.get(1)).getType());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Int type) {
                if (!type.getIsSigned()) {
                    throw new IllegalArgumentException("Unsigned integers are not supported.");
                }
                switch (type.getBitWidth()) {
                    case 8: {
                        return Schema.FieldType.BYTE;
                    }
                    case 16: {
                        return Schema.FieldType.INT16;
                    }
                    case 32: {
                        return Schema.FieldType.INT32;
                    }
                    case 64: {
                        return Schema.FieldType.INT64;
                    }
                }
                throw new IllegalArgumentException("Unsupported integer bit width: " + type.getBitWidth());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case SINGLE: {
                        return Schema.FieldType.FLOAT;
                    }
                    case DOUBLE: {
                        return Schema.FieldType.DOUBLE;
                    }
                }
                throw new IllegalArgumentException("Unsupported floating-point precision: " + type.getPrecision().name());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Utf8 type) {
                return Schema.FieldType.STRING;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Binary type) {
                return Schema.FieldType.BYTES;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FixedSizeBinary type) {
                return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)type.getByteWidth()));
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Bool type) {
                return Schema.FieldType.BOOLEAN;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Decimal type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Date type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Time type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Timestamp type) {
                if (type.getUnit() == TimeUnit.MILLISECOND || type.getUnit() == TimeUnit.MICROSECOND) {
                    return Schema.FieldType.DATETIME;
                }
                throw new IllegalArgumentException("Unsupported timestamp unit: " + type.getUnit().name());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Interval type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Duration type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeBinary type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeUtf8 type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.FieldType visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }
        });
        return fieldType.withNullable(arrowFieldType.isNullable());
    }

    public static @UnknownKeyFor @NonNull @Initialized RecordBatchRowIterator rowsFromRecordBatch(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized VectorSchemaRoot vectorSchemaRoot) {
        return new RecordBatchRowIterator(schema, vectorSchemaRoot);
    }

    public static @UnknownKeyFor @NonNull @Initialized RecordBatchRowIterator rowsFromSerializedRecordBatch(@UnknownKeyFor @NonNull @Initialized org.apache.arrow.vector.types.pojo.Schema arrowSchema, @UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized RootAllocator allocator) throws @UnknownKeyFor @NonNull @Initialized IOException {
        VectorSchemaRoot vectorRoot = VectorSchemaRoot.create((org.apache.arrow.vector.types.pojo.Schema)arrowSchema, (BufferAllocator)allocator);
        VectorLoader vectorLoader = new VectorLoader(vectorRoot);
        vectorRoot.clear();
        try (ReadChannel read = new ReadChannel(Channels.newChannel(inputStream));
             ArrowRecordBatch arrowMessage = MessageSerializer.deserializeRecordBatch((ReadChannel)read, (BufferAllocator)allocator);){
            vectorLoader.load(arrowMessage);
        }
        return ArrowConversion.rowsFromRecordBatch(ArrowSchemaTranslator.toBeamSchema(arrowSchema), vectorRoot);
    }

    public static @UnknownKeyFor @NonNull @Initialized org.apache.arrow.vector.types.pojo.Schema arrowSchemaFromInput(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ReadChannel readChannel = new ReadChannel(Channels.newChannel(input));
        return MessageSerializer.deserializeSchema((ReadChannel)readChannel);
    }

    private ArrowConversion() {
    }

    public static class ArrowSchemaTranslator {
        public static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(@UnknownKeyFor @NonNull @Initialized org.apache.arrow.vector.types.pojo.Schema schema) {
            return ArrowSchemaTranslator.toBeamSchema(schema.getFields());
        }

        public static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields) {
            Schema.Builder builder = Schema.builder();
            for (Field field : fields) {
                Schema.Field beamField = ArrowConversion.toBeamField(field);
                builder.addField(beamField);
            }
            return builder.build();
        }
    }

    public static class RecordBatchRowIterator
    implements Iterator<Row>,
    AutoCloseable {
        private static final @UnknownKeyFor @NonNull @Initialized ArrowValueConverterVisitor valueConverterVisitor = new ArrowValueConverterVisitor();
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized VectorSchemaRoot vectorSchemaRoot;
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> fieldValueGetters;
        private @UnknownKeyFor @NonNull @Initialized Integer currRowIndex;

        private RecordBatchRowIterator(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized VectorSchemaRoot vectorSchemaRoot) {
            this.schema = schema;
            this.vectorSchemaRoot = vectorSchemaRoot;
            this.fieldValueGetters = new CachingFactory((Factory)FieldVectorListValueGetterFactory.of(vectorSchemaRoot.getFieldVectors()));
            this.currRowIndex = 0;
        }

        @Override
        public void close() {
            this.vectorSchemaRoot.close();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return this.currRowIndex < this.vectorSchemaRoot.getRowCount();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("There are no more Rows.");
            }
            Row result = Row.withSchema((Schema)this.schema).withFieldValueGetters(this.fieldValueGetters, (Object)this.currRowIndex);
            this.currRowIndex = this.currRowIndex + 1;
            return result;
        }

        private static class ArrowValueConverterVisitor
        implements ArrowType.ArrowTypeVisitor<Optional<Function<Object, Object>>> {
            private ArrowValueConverterVisitor() {
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Null type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Struct type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.List type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FixedSizeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Union type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Map type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Duration type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Int type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FloatingPoint type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Utf8 type) {
                return Optional.of(text -> ((Text)text).toString());
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Binary type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.FixedSizeBinary type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Bool type) {
                return Optional.empty();
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Decimal type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Date type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Time type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Timestamp type) {
                DateTimeZone tz;
                try {
                    tz = DateTimeZone.forID((String)type.getTimezone());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Encountered unrecognized Timezone: " + type.getTimezone());
                }
                switch (type.getUnit()) {
                    case MICROSECOND: {
                        return Optional.of(epochMicros -> new DateTime((Long)epochMicros / 1000L, tz));
                    }
                    case MILLISECOND: {
                        return Optional.of(epochMills -> new DateTime(((Long)epochMills).longValue(), tz));
                    }
                }
                throw new AssertionError((Object)("Encountered unrecognized TimeUnit: " + type.getUnit()));
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.Interval type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeBinary type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeUtf8 type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }

            public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ArrowType.LargeList type) {
                throw new IllegalArgumentException("Type '" + type.toString() + "' not supported.");
            }
        }

        private static class FieldVectorListValueGetterFactory
        implements Factory<List<FieldValueGetter>> {
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldVector> fieldVectors;

            static @UnknownKeyFor @NonNull @Initialized FieldVectorListValueGetterFactory of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldVector> fieldVectors) {
                return new FieldVectorListValueGetterFactory(fieldVectors);
            }

            private FieldVectorListValueGetterFactory(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldVector> fieldVectors) {
                this.fieldVectors = fieldVectors;
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> create(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema) {
                return this.fieldVectors.stream().map(fieldVector -> {
                    Optional optionalValue = (Optional)fieldVector.getField().getFieldType().getType().accept((ArrowType.ArrowTypeVisitor)valueConverterVisitor);
                    if (!optionalValue.isPresent()) {
                        return new FieldValueGetter<Integer, Object>(){

                            @javax.annotation.Nullable
                            public @UnknownKeyFor @Nullable @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Integer rowIndex) {
                                return fieldVector.getObject(rowIndex.intValue());
                            }

                            public @UnknownKeyFor @NonNull @Initialized String name() {
                                return fieldVector.getField().getName();
                            }
                        };
                    }
                    final Function conversionFunction = (Function)optionalValue.get();
                    return new FieldValueGetter<Integer, Object>(){

                        @javax.annotation.Nullable
                        public @UnknownKeyFor @Nullable @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Integer rowIndex) {
                            Object value = fieldVector.getObject(rowIndex.intValue());
                            if (value == null) {
                                return null;
                            }
                            return conversionFunction.apply(value);
                        }

                        public @UnknownKeyFor @NonNull @Initialized String name() {
                            return fieldVector.getField().getName();
                        }
                    };
                }).collect(Collectors.toList());
            }
        }
    }
}

