/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.arrow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.apache.beam.sdk.extensions.arrow.ArrowConversion;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ArrowConversionTest {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void teardown() {
        this.allocator.close();
    }

    @Test
    public void toBeamSchema_convertsSimpleArrowSchema() {
        Schema expected = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"int8", (Schema.FieldType)Schema.FieldType.BYTE), Schema.Field.of((String)"int16", (Schema.FieldType)Schema.FieldType.INT16)});
        org.apache.arrow.vector.types.pojo.Schema arrowSchema = new org.apache.arrow.vector.types.pojo.Schema((Iterable)ImmutableList.of((Object)ArrowConversionTest.field("int8", (ArrowType)new ArrowType.Int(8, true), new Field[0]), (Object)ArrowConversionTest.field("int16", (ArrowType)new ArrowType.Int(16, true), new Field[0])));
        MatcherAssert.assertThat((Object)ArrowConversion.ArrowSchemaTranslator.toBeamSchema((org.apache.arrow.vector.types.pojo.Schema)arrowSchema), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void rowIterator() {
        org.apache.arrow.vector.types.pojo.Schema schema = new org.apache.arrow.vector.types.pojo.Schema(Arrays.asList(ArrowConversionTest.field("int32", (ArrowType)new ArrowType.Int(32, true), new Field[0]), ArrowConversionTest.field("float64", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), new Field[0]), ArrowConversionTest.field("string", (ArrowType)new ArrowType.Utf8(), new Field[0]), ArrowConversionTest.field("timestampMicroUTC", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC"), new Field[0]), ArrowConversionTest.field("timestampMilliUTC", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), new Field[0]), ArrowConversionTest.field("int32_list", (ArrowType)new ArrowType.List(), ArrowConversionTest.field("int32s", (ArrowType)new ArrowType.Int(32, true), new Field[0])), ArrowConversionTest.field("boolean", (ArrowType)new ArrowType.Bool(), new Field[0]), ArrowConversionTest.field("fixed_size_binary", (ArrowType)new ArrowType.FixedSizeBinary(3), new Field[0])));
        Schema beamSchema = ArrowConversion.ArrowSchemaTranslator.toBeamSchema((org.apache.arrow.vector.types.pojo.Schema)schema);
        VectorSchemaRoot expectedSchemaRoot = VectorSchemaRoot.create((org.apache.arrow.vector.types.pojo.Schema)schema, (BufferAllocator)this.allocator);
        expectedSchemaRoot.allocateNew();
        expectedSchemaRoot.setRowCount(16);
        IntVector intVector = (IntVector)expectedSchemaRoot.getFieldVectors().get(0);
        Float8Vector floatVector = (Float8Vector)expectedSchemaRoot.getFieldVectors().get(1);
        VarCharVector strVector = (VarCharVector)expectedSchemaRoot.getFieldVectors().get(2);
        TimeStampMicroTZVector timestampMicroUtcVector = (TimeStampMicroTZVector)expectedSchemaRoot.getFieldVectors().get(3);
        TimeStampMilliTZVector timeStampMilliTZVector = (TimeStampMilliTZVector)expectedSchemaRoot.getFieldVectors().get(4);
        ListVector int32ListVector = (ListVector)expectedSchemaRoot.getFieldVectors().get(5);
        IntVector int32ListElementVector = (IntVector)int32ListVector.addOrGetVector(new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null)).getVector();
        BitVector boolVector = (BitVector)expectedSchemaRoot.getFieldVectors().get(6);
        FixedSizeBinaryVector fixedSizeBinaryVector = (FixedSizeBinaryVector)expectedSchemaRoot.getFieldVectors().get(7);
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (int i = 0; i < 16; ++i) {
            DateTime dt = new DateTime(2019, 1, i + 1, i, i, i, DateTimeZone.UTC);
            expectedRows.add(Row.withSchema((Schema)beamSchema).addValues(new Object[]{i, (double)i + 0.1 * (double)i, "" + i, dt, dt, ImmutableList.of((Object)i), i % 2 != 0, new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)}}).build());
            intVector.set(i, i);
            floatVector.set(i, (double)i + 0.1 * (double)i);
            strVector.set(i, new Text("" + i));
            timestampMicroUtcVector.set(i, dt.getMillis() * 1000L);
            timeStampMilliTZVector.set(i, dt.getMillis());
            int32ListVector.startNewValue(i);
            int32ListElementVector.set(i, i);
            int32ListVector.endValue(i, 1);
            boolVector.set(i, i % 2);
            fixedSizeBinaryVector.set(i, new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)});
        }
        MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterator)ArrowConversion.rowsFromRecordBatch((Schema)beamSchema, (VectorSchemaRoot)expectedSchemaRoot)), (Matcher)IsIterableContainingInOrder.contains((List)((List)expectedRows.stream().map(row -> Matchers.equalTo((Object)row)).collect(ImmutableList.toImmutableList()))));
        expectedSchemaRoot.close();
    }

    private static Field field(String name, boolean nullable, ArrowType type, Field ... children) {
        return new Field(name, new FieldType(nullable, type, null, null), Arrays.asList(children));
    }

    private static Field field(String name, ArrowType type, Field ... children) {
        return ArrowConversionTest.field(name, false, type, children);
    }
}

