/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.io.AvroSink;
import org.apache.beam.sdk.extensions.avro.io.DynamicAvroDestinations;
import org.apache.beam.sdk.extensions.avro.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_AvroIO_TypedWrite<UserT, DestinationT, OutputT>
extends AvroIO.TypedWrite<UserT, DestinationT, OutputT> {
    private final @Nullable SerializableFunction<UserT, OutputT> formatFunction;
    private final @Nullable ValueProvider<ResourceId> filenamePrefix;
    private final @Nullable String shardTemplate;
    private final @Nullable String filenameSuffix;
    private final @Nullable ValueProvider<ResourceId> tempDirectory;
    private final int numShards;
    private final Class<OutputT> recordClass;
    private final int syncInterval;
    private final @Nullable Schema schema;
    private final boolean windowedWrites;
    private final boolean noSpilling;
    private final @Nullable Integer maxNumWritersPerBundle;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FileBasedSink.FilenamePolicy filenamePolicy;
    private final @Nullable DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations;
    private final @Nullable AvroSink.DatumWriterFactory<OutputT> datumWriterFactory;
    private final @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler;
    private final SerializableAvroCodecFactory codec;
    private final ImmutableMap<String, Object> metadata;

    private AutoValue_AvroIO_TypedWrite(@Nullable SerializableFunction<UserT, OutputT> formatFunction, @Nullable ValueProvider<ResourceId> filenamePrefix, @Nullable String shardTemplate, @Nullable String filenameSuffix, @Nullable ValueProvider<ResourceId> tempDirectory, int numShards, Class<OutputT> recordClass, int syncInterval, @Nullable Schema schema, boolean windowedWrites, boolean noSpilling, @Nullable Integer maxNumWritersPerBundle, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FileBasedSink.FilenamePolicy filenamePolicy, @Nullable DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations, @Nullable AvroSink.DatumWriterFactory<OutputT> datumWriterFactory, @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler, SerializableAvroCodecFactory codec, ImmutableMap<String, Object> metadata) {
        this.formatFunction = formatFunction;
        this.filenamePrefix = filenamePrefix;
        this.shardTemplate = shardTemplate;
        this.filenameSuffix = filenameSuffix;
        this.tempDirectory = tempDirectory;
        this.numShards = numShards;
        this.recordClass = recordClass;
        this.syncInterval = syncInterval;
        this.schema = schema;
        this.windowedWrites = windowedWrites;
        this.noSpilling = noSpilling;
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
        this.filenamePolicy = filenamePolicy;
        this.dynamicDestinations = dynamicDestinations;
        this.datumWriterFactory = datumWriterFactory;
        this.badRecordErrorHandler = badRecordErrorHandler;
        this.codec = codec;
        this.metadata = metadata;
    }

    @Override
    @Nullable SerializableFunction<UserT, OutputT> getFormatFunction() {
        return this.formatFunction;
    }

    @Override
    @Nullable ValueProvider<ResourceId> getFilenamePrefix() {
        return this.filenamePrefix;
    }

    @Override
    @Nullable String getShardTemplate() {
        return this.shardTemplate;
    }

    @Override
    @Nullable String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    @Override
    @Nullable ValueProvider<ResourceId> getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    int getNumShards() {
        return this.numShards;
    }

    @Override
    Class<OutputT> getRecordClass() {
        return this.recordClass;
    }

    @Override
    int getSyncInterval() {
        return this.syncInterval;
    }

    @Override
    @Nullable Schema getSchema() {
        return this.schema;
    }

    @Override
    boolean getWindowedWrites() {
        return this.windowedWrites;
    }

    @Override
    boolean getNoSpilling() {
        return this.noSpilling;
    }

    @Override
    @Nullable Integer getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    @Override
    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FileBasedSink.FilenamePolicy getFilenamePolicy() {
        return this.filenamePolicy;
    }

    @Override
    @Nullable DynamicAvroDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    @Override
    @Nullable AvroSink.DatumWriterFactory<OutputT> getDatumWriterFactory() {
        return this.datumWriterFactory;
    }

    @Override
    @Nullable ErrorHandler<BadRecord, ?> getBadRecordErrorHandler() {
        return this.badRecordErrorHandler;
    }

    @Override
    SerializableAvroCodecFactory getCodec() {
        return this.codec;
    }

    @Override
    ImmutableMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AvroIO.TypedWrite) {
            AvroIO.TypedWrite that = (AvroIO.TypedWrite)((Object)o);
            return (this.formatFunction == null ? that.getFormatFunction() == null : this.formatFunction.equals(that.getFormatFunction())) && (this.filenamePrefix == null ? that.getFilenamePrefix() == null : this.filenamePrefix.equals(that.getFilenamePrefix())) && (this.shardTemplate == null ? that.getShardTemplate() == null : this.shardTemplate.equals(that.getShardTemplate())) && (this.filenameSuffix == null ? that.getFilenameSuffix() == null : this.filenameSuffix.equals(that.getFilenameSuffix())) && (this.tempDirectory == null ? that.getTempDirectory() == null : this.tempDirectory.equals(that.getTempDirectory())) && this.numShards == that.getNumShards() && this.recordClass.equals(that.getRecordClass()) && this.syncInterval == that.getSyncInterval() && (this.schema == null ? that.getSchema() == null : this.schema.equals((Object)that.getSchema())) && this.windowedWrites == that.getWindowedWrites() && this.noSpilling == that.getNoSpilling() && (this.maxNumWritersPerBundle == null ? that.getMaxNumWritersPerBundle() == null : this.maxNumWritersPerBundle.equals(that.getMaxNumWritersPerBundle())) && (this.filenamePolicy == null ? that.getFilenamePolicy() == null : this.filenamePolicy.equals(that.getFilenamePolicy())) && (this.dynamicDestinations == null ? that.getDynamicDestinations() == null : ((Object)this.dynamicDestinations).equals((Object)that.getDynamicDestinations())) && (this.datumWriterFactory == null ? that.getDatumWriterFactory() == null : this.datumWriterFactory.equals(that.getDatumWriterFactory())) && (this.badRecordErrorHandler == null ? that.getBadRecordErrorHandler() == null : this.badRecordErrorHandler.equals(that.getBadRecordErrorHandler())) && this.codec.equals(that.getCodec()) && this.metadata.equals(that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.formatFunction == null ? 0 : this.formatFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenamePrefix == null ? 0 : this.filenamePrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.shardTemplate == null ? 0 : this.shardTemplate.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenameSuffix == null ? 0 : this.filenameSuffix.hashCode();
        h$ *= 1000003;
        h$ ^= this.tempDirectory == null ? 0 : this.tempDirectory.hashCode();
        h$ *= 1000003;
        h$ ^= this.numShards;
        h$ *= 1000003;
        h$ ^= this.recordClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.syncInterval;
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.windowedWrites ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.noSpilling ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxNumWritersPerBundle == null ? 0 : this.maxNumWritersPerBundle.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenamePolicy == null ? 0 : this.filenamePolicy.hashCode();
        h$ *= 1000003;
        h$ ^= this.dynamicDestinations == null ? 0 : ((Object)this.dynamicDestinations).hashCode();
        h$ *= 1000003;
        h$ ^= this.datumWriterFactory == null ? 0 : this.datumWriterFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.badRecordErrorHandler == null ? 0 : this.badRecordErrorHandler.hashCode();
        h$ *= 1000003;
        h$ ^= this.codec.hashCode();
        h$ *= 1000003;
        return h$ ^= this.metadata.hashCode();
    }

    @Override
    AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<UserT, DestinationT, OutputT>
    extends AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> {
        private @Nullable SerializableFunction<UserT, OutputT> formatFunction;
        private @Nullable ValueProvider<ResourceId> filenamePrefix;
        private @Nullable String shardTemplate;
        private @Nullable String filenameSuffix;
        private @Nullable ValueProvider<ResourceId> tempDirectory;
        private Integer numShards;
        private Class<OutputT> recordClass;
        private Integer syncInterval;
        private @Nullable Schema schema;
        private Boolean windowedWrites;
        private Boolean noSpilling;
        private @Nullable Integer maxNumWritersPerBundle;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable FileBasedSink.FilenamePolicy filenamePolicy;
        private @Nullable DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations;
        private @Nullable AvroSink.DatumWriterFactory<OutputT> datumWriterFactory;
        private @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler;
        private SerializableAvroCodecFactory codec;
        private ImmutableMap<String, Object> metadata;

        Builder() {
        }

        private Builder(AvroIO.TypedWrite<UserT, DestinationT, OutputT> source) {
            this.formatFunction = source.getFormatFunction();
            this.filenamePrefix = source.getFilenamePrefix();
            this.shardTemplate = source.getShardTemplate();
            this.filenameSuffix = source.getFilenameSuffix();
            this.tempDirectory = source.getTempDirectory();
            this.numShards = source.getNumShards();
            this.recordClass = source.getRecordClass();
            this.syncInterval = source.getSyncInterval();
            this.schema = source.getSchema();
            this.windowedWrites = source.getWindowedWrites();
            this.noSpilling = source.getNoSpilling();
            this.maxNumWritersPerBundle = source.getMaxNumWritersPerBundle();
            this.filenamePolicy = source.getFilenamePolicy();
            this.dynamicDestinations = source.getDynamicDestinations();
            this.datumWriterFactory = source.getDatumWriterFactory();
            this.badRecordErrorHandler = source.getBadRecordErrorHandler();
            this.codec = source.getCodec();
            this.metadata = source.getMetadata();
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setFormatFunction(@Nullable SerializableFunction<UserT, OutputT> formatFunction) {
            this.formatFunction = formatFunction;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setFilenamePrefix(ValueProvider<ResourceId> filenamePrefix) {
            this.filenamePrefix = filenamePrefix;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setShardTemplate(@Nullable String shardTemplate) {
            this.shardTemplate = shardTemplate;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setFilenameSuffix(@Nullable String filenameSuffix) {
            this.filenameSuffix = filenameSuffix;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setTempDirectory(ValueProvider<ResourceId> tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setRecordClass(Class<OutputT> recordClass) {
            if (recordClass == null) {
                throw new NullPointerException("Null recordClass");
            }
            this.recordClass = recordClass;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setSyncInterval(int syncInterval) {
            this.syncInterval = syncInterval;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setWindowedWrites(boolean windowedWrites) {
            this.windowedWrites = windowedWrites;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setNoSpilling(boolean noSpilling) {
            this.noSpilling = noSpilling;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setMaxNumWritersPerBundle(@Nullable Integer maxNumWritersPerBundle) {
            this.maxNumWritersPerBundle = maxNumWritersPerBundle;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setFilenamePolicy(FileBasedSink.FilenamePolicy filenamePolicy) {
            this.filenamePolicy = filenamePolicy;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setDynamicDestinations(DynamicAvroDestinations<UserT, DestinationT, OutputT> dynamicDestinations) {
            this.dynamicDestinations = dynamicDestinations;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setDatumWriterFactory(AvroSink.DatumWriterFactory<OutputT> datumWriterFactory) {
            this.datumWriterFactory = datumWriterFactory;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setBadRecordErrorHandler(@Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler) {
            this.badRecordErrorHandler = badRecordErrorHandler;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setCodec(SerializableAvroCodecFactory codec) {
            if (codec == null) {
                throw new NullPointerException("Null codec");
            }
            this.codec = codec;
            return this;
        }

        @Override
        AvroIO.TypedWrite.Builder<UserT, DestinationT, OutputT> setMetadata(ImmutableMap<String, Object> metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        AvroIO.TypedWrite<UserT, DestinationT, OutputT> build() {
            if (this.numShards == null || this.recordClass == null || this.syncInterval == null || this.windowedWrites == null || this.noSpilling == null || this.codec == null || this.metadata == null) {
                StringBuilder missing = new StringBuilder();
                if (this.numShards == null) {
                    missing.append(" numShards");
                }
                if (this.recordClass == null) {
                    missing.append(" recordClass");
                }
                if (this.syncInterval == null) {
                    missing.append(" syncInterval");
                }
                if (this.windowedWrites == null) {
                    missing.append(" windowedWrites");
                }
                if (this.noSpilling == null) {
                    missing.append(" noSpilling");
                }
                if (this.codec == null) {
                    missing.append(" codec");
                }
                if (this.metadata == null) {
                    missing.append(" metadata");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AvroIO_TypedWrite(this.formatFunction, this.filenamePrefix, this.shardTemplate, this.filenameSuffix, this.tempDirectory, this.numShards, this.recordClass, this.syncInterval, this.schema, this.windowedWrites, this.noSpilling, this.maxNumWritersPerBundle, this.filenamePolicy, this.dynamicDestinations, this.datumWriterFactory, this.badRecordErrorHandler, this.codec, this.metadata);
        }
    }
}

