/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class ParseJsons<OutputT>
extends PTransform<PCollection<String>, PCollection<OutputT>> {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final Class<? extends OutputT> outputClass;
    private ObjectMapper customMapper;

    public static <OutputT> ParseJsons<OutputT> of(Class<? extends OutputT> outputClass) {
        return new ParseJsons<OutputT>(outputClass);
    }

    private ParseJsons(Class<? extends OutputT> outputClass) {
        this.outputClass = outputClass;
    }

    public ParseJsons<OutputT> withMapper(ObjectMapper mapper) {
        ParseJsons<? extends OutputT> newTransform = new ParseJsons<OutputT>(this.outputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <NewFailureT> ParseJsonsWithFailures<NewFailureT> exceptionsInto(TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new ParseJsonsWithFailures<NewFailureT>(null, failureTypeDescriptor);
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <FailureT> ParseJsonsWithFailures<FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<String>, FailureT> exceptionHandler) {
        return new ParseJsonsWithFailures<FailureT>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public ParseJsonsWithFailures<KV<String, Map<String, String>>> exceptionsVia() {
        DefaultExceptionAsMapHandler<String> exceptionHandler = new DefaultExceptionAsMapHandler<String>(){};
        return new ParseJsonsWithFailures<KV<String, Map<String, String>>>((InferableFunction<WithFailures.ExceptionElement<String>, KV<String, Map<String, String>>>)exceptionHandler, (TypeDescriptor<KV<String, Map<String, String>>>)exceptionHandler.getOutputTypeDescriptor());
    }

    private OutputT readValue(String input) throws IOException {
        ObjectMapper mapper = Optional.ofNullable(this.customMapper).orElse(DEFAULT_MAPPER);
        return (OutputT)mapper.readValue(input, this.outputClass);
    }

    public PCollection<OutputT> expand(PCollection<String> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, OutputT>(){

            public OutputT apply(String input) {
                try {
                    return ParseJsons.this.readValue(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse a " + ParseJsons.this.outputClass.getName() + " from JSON value: " + input, e);
                }
            }
        }));
    }

    private static class DefaultExceptionAsMapHandler<OutputT>
    extends SimpleFunction<WithFailures.ExceptionElement<OutputT>, KV<OutputT, Map<String, String>>> {
        private DefaultExceptionAsMapHandler() {
        }

        public KV<OutputT, Map<String, String>> apply(WithFailures.ExceptionElement<OutputT> f) throws RuntimeException {
            if (!(f.exception() instanceof IOException)) {
                throw new RuntimeException(f.exception());
            }
            return KV.of((Object)f.element(), (Object)ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public class ParseJsonsWithFailures<FailureT>
    extends PTransform<PCollection<String>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        @Nullable
        private InferableFunction<WithFailures.ExceptionElement<String>, FailureT> exceptionHandler;
        @Nullable
        private final transient TypeDescriptor<FailureT> failureType;

        ParseJsonsWithFailures(InferableFunction<WithFailures.ExceptionElement<String>, FailureT> exceptionHandler, TypeDescriptor<FailureT> failureType) {
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public ParseJsonsWithFailures<FailureT> exceptionsVia(ProcessFunction<WithFailures.ExceptionElement<String>, FailureT> exceptionHandler) {
            return new ParseJsonsWithFailures<FailureT>(new InferableFunction<WithFailures.ExceptionElement<String>, FailureT>(exceptionHandler){}, this.failureType);
        }

        public WithFailures.Result<PCollection<OutputT>, FailureT> expand(PCollection<String> input) {
            return (WithFailures.Result)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<OutputT>(){}).via(Contextful.fn((Contextful.Fn & Serializable)(input1, c) -> ParseJsons.this.readValue(input1), (Requirements)Requirements.empty())).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
        }
    }
}

