/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsJsons<InputT>
extends PTransform<PCollection<InputT>, PCollection<String>> {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final Class<? extends InputT> inputClass;
    private ObjectMapper customMapper;

    public static <InputT> AsJsons<InputT> of(Class<? extends InputT> inputClass) {
        return new AsJsons<InputT>(inputClass);
    }

    private AsJsons(Class<? extends InputT> inputClass) {
        this.inputClass = inputClass;
    }

    public AsJsons<InputT> withMapper(ObjectMapper mapper) {
        AsJsons<? extends InputT> newTransform = new AsJsons<InputT>(this.inputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <NewFailureT> AsJsonsWithFailures<NewFailureT> exceptionsInto(TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new AsJsonsWithFailures<NewFailureT>(null, failureTypeDescriptor);
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <FailureT> AsJsonsWithFailures<FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new AsJsonsWithFailures<FailureT>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public AsJsonsWithFailures<KV<InputT, Map<String, String>>> exceptionsVia() {
        DefaultExceptionAsMapHandler exceptionHandler = new DefaultExceptionAsMapHandler<InputT>(){};
        return new AsJsonsWithFailures<KV<InputT, Map<String, String>>>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    private String writeValue(InputT input) throws JsonProcessingException {
        ObjectMapper mapper = Optional.ofNullable(this.customMapper).orElse(DEFAULT_MAPPER);
        return mapper.writeValueAsString(input);
    }

    public PCollection<String> expand(PCollection<InputT> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<InputT, String>(){

            public String apply(InputT input) {
                try {
                    return AsJsons.this.writeValue(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize " + AsJsons.this.inputClass.getName() + " value: " + input, e);
                }
            }
        }));
    }

    private static class DefaultExceptionAsMapHandler<InputT>
    extends SimpleFunction<WithFailures.ExceptionElement<InputT>, KV<InputT, Map<String, String>>> {
        private DefaultExceptionAsMapHandler() {
        }

        public KV<InputT, Map<String, String>> apply(WithFailures.ExceptionElement<InputT> f) throws RuntimeException {
            if (!(f.exception() instanceof JsonProcessingException)) {
                throw new RuntimeException(f.exception());
            }
            return KV.of((Object)f.element(), (Object)ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public class AsJsonsWithFailures<FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<String>, FailureT>> {
        private @Nullable InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;
        private final transient @Nullable TypeDescriptor<FailureT> failureType;

        AsJsonsWithFailures(InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, TypeDescriptor<FailureT> failureType) {
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public AsJsonsWithFailures<FailureT> exceptionsVia(ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new AsJsonsWithFailures<FailureT>(new InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT>(exceptionHandler){}, this.failureType);
        }

        public WithFailures.Result<PCollection<String>, FailureT> expand(PCollection<InputT> input) {
            return (WithFailures.Result)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(Contextful.fn((Contextful.Fn & Serializable)(input1, c) -> AsJsons.this.writeValue(input1), (Requirements)Requirements.empty())).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
        }
    }
}

