/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.kryo;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.KryoException;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.InputChunked;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.OutputChunked;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.kryo.KryoOptions;
import org.apache.beam.sdk.extensions.kryo.KryoRegistrar;
import org.apache.beam.sdk.extensions.kryo.KryoState;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class KryoCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized String instanceId = UUID.randomUUID().toString();
    private final @UnknownKeyFor @NonNull @Initialized SerializableOptions options;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars;

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of() {
        return KryoCoder.of(PipelineOptionsFactory.create(), Collections.emptyList());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of(KryoRegistrar ... registrars) {
        return KryoCoder.of(PipelineOptionsFactory.create(), registrars);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars) {
        return KryoCoder.of(PipelineOptionsFactory.create(), registrars);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        return KryoCoder.of(pipelineOptions, Collections.emptyList());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, KryoRegistrar ... registrars) {
        return KryoCoder.of(pipelineOptions, Arrays.asList(registrars));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KryoCoder<T> of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars) {
        KryoOptions kryoOptions = (KryoOptions)pipelineOptions.as(KryoOptions.class);
        return new KryoCoder<T>(new SerializableOptions(kryoOptions.getKryoBufferSize(), kryoOptions.getKryoReferences(), kryoOptions.getKryoRegistrationRequired()), registrars);
    }

    private KryoCoder(@UnknownKeyFor @NonNull @Initialized SerializableOptions options, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars) {
        this.options = options;
        this.registrars = registrars;
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        KryoState kryoState = KryoState.get(this);
        if (value == null) {
            throw new CoderException("Cannot encode a null value.");
        }
        OutputChunked outputChunked = kryoState.getOutputChunked();
        outputChunked.setOutputStream(outStream);
        try {
            kryoState.getKryo().writeClassAndObject(outputChunked, value);
            outputChunked.endChunk();
            outputChunked.flush();
        }
        catch (KryoException e) {
            outputChunked.reset();
            if (e.getCause() instanceof EOFException) {
                throw (EOFException)e.getCause();
            }
            throw new CoderException("Cannot encode given object of type [" + value.getClass() + "].", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("Class is not registered")) {
                throw new CoderException(message);
            }
            throw e;
        }
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        KryoState kryoState = KryoState.get(this);
        InputChunked inputChunked = kryoState.getInputChunked();
        inputChunked.setInputStream(inStream);
        try {
            Object instance = kryoState.getKryo().readClassAndObject(inputChunked);
            return (T)instance;
        }
        catch (KryoException e) {
            throw new CoderException("Cannot decode object from input stream.", (Throwable)e);
        }
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
    }

    public @UnknownKeyFor @NonNull @Initialized KryoCoder<T> withRegistrar(@UnknownKeyFor @NonNull @Initialized KryoRegistrar registrar) {
        ArrayList<KryoRegistrar> newRegistrars = new ArrayList<KryoRegistrar>(this.registrars);
        this.registrars.add(registrar);
        return new KryoCoder<T>(this.options, newRegistrars);
    }

    @UnknownKeyFor @NonNull @Initialized String getInstanceId() {
        return this.instanceId;
    }

    @UnknownKeyFor @NonNull @Initialized SerializableOptions getOptions() {
        return this.options;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> getRegistrars() {
        return this.registrars;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.instanceId.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other != null && ((Object)((Object)this)).getClass().equals(other.getClass())) {
            return this.instanceId.equals(((KryoCoder)((Object)other)).instanceId);
        }
        return false;
    }

    static class SerializableOptions
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized int bufferSize;
        private final @UnknownKeyFor @NonNull @Initialized boolean references;
        private final @UnknownKeyFor @NonNull @Initialized boolean registrationRequired;

        private SerializableOptions(@UnknownKeyFor @NonNull @Initialized int bufferSize, @UnknownKeyFor @NonNull @Initialized boolean references, @UnknownKeyFor @NonNull @Initialized boolean registrationRequired) {
            this.bufferSize = bufferSize;
            this.references = references;
            this.registrationRequired = registrationRequired;
        }

        @UnknownKeyFor @NonNull @Initialized int getBufferSize() {
            return this.bufferSize;
        }

        @UnknownKeyFor @NonNull @Initialized boolean getReferences() {
            return this.references;
        }

        @UnknownKeyFor @NonNull @Initialized boolean getRegistrationRequired() {
            return this.registrationRequired;
        }
    }
}

