/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.kryo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.Kryo;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.InputChunked;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.OutputChunked;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import org.apache.beam.repackaged.kryo.org.objenesis.strategy.StdInstantiatorStrategy;
import org.apache.beam.sdk.extensions.kryo.KryoCoder;
import org.apache.beam.sdk.extensions.kryo.KryoRegistrar;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class KryoState {
    private static final @UnknownKeyFor @NonNull @Initialized Storage STORAGE = new Storage();
    private final @UnknownKeyFor @NonNull @Initialized Kryo kryo;
    private final @UnknownKeyFor @NonNull @Initialized int firstRegistrationId;
    private final @UnknownKeyFor @NonNull @Initialized InputChunked inputChunked;
    private final @UnknownKeyFor @NonNull @Initialized OutputChunked outputChunked;

    static @UnknownKeyFor @NonNull @Initialized KryoState get(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KryoCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        return STORAGE.getOrCreate(coder);
    }

    private KryoState(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized int firstRegistrationId, @UnknownKeyFor @NonNull @Initialized InputChunked inputChunked, @UnknownKeyFor @NonNull @Initialized OutputChunked outputChunked) {
        this.kryo = kryo;
        this.firstRegistrationId = firstRegistrationId;
        this.inputChunked = inputChunked;
        this.outputChunked = outputChunked;
    }

    @UnknownKeyFor @NonNull @Initialized Kryo getKryo() {
        return this.kryo;
    }

    public @UnknownKeyFor @NonNull @Initialized int getFirstRegistrationId() {
        return this.firstRegistrationId;
    }

    @UnknownKeyFor @NonNull @Initialized InputChunked getInputChunked() {
        return this.inputChunked;
    }

    @UnknownKeyFor @NonNull @Initialized OutputChunked getOutputChunked() {
        return this.outputChunked;
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Spotbugs incorrectly thinks kryoStateMap is marked @Nullable")
    private static class Storage {
        private final @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryoState>> kryoStateMap = ThreadLocal.withInitial(HashMap::new);

        private Storage() {
        }

        @UnknownKeyFor @NonNull @Initialized KryoState getOrCreate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized KryoCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
            return this.kryoStateMap.get().computeIfAbsent(coder.getInstanceId(), k -> {
                Kryo kryo = new Kryo();
                kryo.setInstantiatorStrategy(new DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
                kryo.setReferences(coder.getOptions().getReferences());
                kryo.setRegistrationRequired(coder.getOptions().getRegistrationRequired());
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    throw new RuntimeException("Cannot detect classpath: classload is null (is it the bootstrap classloader?)");
                }
                kryo.setClassLoader(classLoader);
                int firstRegistrationId = kryo.getNextRegistrationId();
                for (KryoRegistrar registrar : coder.getRegistrars()) {
                    registrar.registerClasses(kryo);
                }
                return new KryoState(kryo, firstRegistrationId, new InputChunked(coder.getOptions().getBufferSize()), new OutputChunked(coder.getOptions().getBufferSize()));
            });
        }
    }
}

