/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.kryo;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.ClassResolver;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.Kryo;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.Registration;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.extensions.kryo.KryoCoder;
import org.apache.beam.sdk.extensions.kryo.KryoOptions;
import org.apache.beam.sdk.extensions.kryo.KryoRegistrar;
import org.apache.beam.sdk.extensions.kryo.KryoState;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KryoCoderProvider
extends CoderProvider {
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Object> OBJECT_TYPE = new TypeDescriptor<Object>(){};
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KryoCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of() {
        return KryoCoderProvider.of(PipelineOptionsFactory.create(), Collections.emptyList());
    }

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of(KryoRegistrar ... registrars) {
        return KryoCoderProvider.of(PipelineOptionsFactory.create(), Arrays.asList(registrars));
    }

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars) {
        return KryoCoderProvider.of(PipelineOptionsFactory.create(), registrars);
    }

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        return KryoCoderProvider.of(pipelineOptions, Collections.emptyList());
    }

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, KryoRegistrar ... registrars) {
        return KryoCoderProvider.of(pipelineOptions, Arrays.asList(registrars));
    }

    public static @UnknownKeyFor @NonNull @Initialized KryoCoderProvider of(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KryoRegistrar> registrars) {
        KryoOptions kryoOptions = (KryoOptions)pipelineOptions.as(KryoOptions.class);
        return new KryoCoderProvider(KryoCoder.of((PipelineOptions)kryoOptions, registrars));
    }

    private KryoCoderProvider(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KryoCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        this.coder = coder;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        if (this.hasUserProvidedRegistration(typeDescriptor)) {
            return this.coder;
        }
        if (OBJECT_TYPE.equals(typeDescriptor)) {
            return this.coder;
        }
        throw new CannotProvideCoderException(String.format("Cannot provide [%s], given type descriptor's [%s] raw type is not registered in Kryo.", KryoCoder.class.getSimpleName(), typeDescriptor));
    }

    private <T> @UnknownKeyFor @NonNull @Initialized boolean hasUserProvidedRegistration(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        KryoState kryoState = KryoState.get(this.coder);
        Class rawType = typeDescriptor.getRawType();
        Kryo kryo = kryoState.getKryo();
        ClassResolver classResolver = kryo.getClassResolver();
        Registration registration = classResolver.getRegistration(rawType);
        return registration != null && registration.getId() >= kryoState.getFirstRegistrationId();
    }

    public @UnknownKeyFor @NonNull @Initialized KryoCoderProvider withRegistrar(@UnknownKeyFor @NonNull @Initialized KryoRegistrar registrar) {
        return new KryoCoderProvider(this.coder.withRegistrar(registrar));
    }

    public void registerTo(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        pipeline.getCoderRegistry().registerCoderProvider((CoderProvider)this);
    }

    @VisibleForTesting
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KryoCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoder() {
        return this.coder;
    }
}

