/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.kryo.org.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import org.apache.beam.repackaged.kryo.org.objenesis.ObjenesisException;
import org.apache.beam.repackaged.kryo.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.beam.repackaged.kryo.org.objenesis.instantiator.annotations.Instantiator;
import org.apache.beam.repackaged.kryo.org.objenesis.instantiator.annotations.Typology;
import org.apache.beam.repackaged.kryo.org.objenesis.instantiator.sun.SunReflectionFactoryHelper;

@Instantiator(value=Typology.STANDARD)
public class SunReflectionFactoryInstantiator<T>
implements ObjectInstantiator<T> {
    private final Constructor<T> mungedConstructor;

    public SunReflectionFactoryInstantiator(Class<T> type) {
        Constructor<Object> javaLangObjectConstructor = SunReflectionFactoryInstantiator.getJavaLangObjectConstructor();
        this.mungedConstructor = SunReflectionFactoryHelper.newConstructorForSerialization(type, javaLangObjectConstructor);
        this.mungedConstructor.setAccessible(true);
    }

    @Override
    public T newInstance() {
        try {
            return this.mungedConstructor.newInstance(null);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }

    private static Constructor<Object> getJavaLangObjectConstructor() {
        try {
            return Object.class.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(e);
        }
    }
}

