/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.serializers;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.Kryo;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.Serializer;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.Input;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.io.Output;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.serializers.ImmutableSerializer;
import org.apache.beam.repackaged.kryo.com.esotericsoftware.kryo.util.Util;

public final class OptionalSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.util.Optional")) {
            kryo.addDefaultSerializer(Optional.class, OptionalSerializer.class);
        }
        if (Util.isClassAvailable("java.util.OptionalInt")) {
            kryo.addDefaultSerializer(OptionalInt.class, OptionalIntSerializer.class);
        }
        if (Util.isClassAvailable("java.util.OptionalLong")) {
            kryo.addDefaultSerializer(OptionalLong.class, OptionalLongSerializer.class);
        }
        if (Util.isClassAvailable("java.util.OptionalDouble")) {
            kryo.addDefaultSerializer(OptionalDouble.class, OptionalDoubleSerializer.class);
        }
    }

    public static class OptionalDoubleSerializer
    extends ImmutableSerializer<OptionalDouble> {
        @Override
        public void write(Kryo kryo, Output output, OptionalDouble object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeDouble(object.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(Kryo kryo, Input input, Class type) {
            boolean present = input.readBoolean();
            return present ? OptionalDouble.of(input.readDouble()) : OptionalDouble.empty();
        }
    }

    public static class OptionalLongSerializer
    extends ImmutableSerializer<OptionalLong> {
        @Override
        public void write(Kryo kryo, Output output, OptionalLong object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeLong(object.getAsLong());
            }
        }

        @Override
        public OptionalLong read(Kryo kryo, Input input, Class type) {
            boolean present = input.readBoolean();
            return present ? OptionalLong.of(input.readLong()) : OptionalLong.empty();
        }
    }

    public static class OptionalIntSerializer
    extends ImmutableSerializer<OptionalInt> {
        @Override
        public void write(Kryo kryo, Output output, OptionalInt object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeInt(object.getAsInt());
            }
        }

        @Override
        public OptionalInt read(Kryo kryo, Input input, Class type) {
            boolean present = input.readBoolean();
            return present ? OptionalInt.of(input.readInt()) : OptionalInt.empty();
        }
    }

    public static class OptionalSerializer
    extends Serializer<Optional> {
        public OptionalSerializer() {
            this.setAcceptsNull(false);
        }

        @Override
        public void write(Kryo kryo, Output output, Optional object) {
            Object nullable = object.isPresent() ? object.get() : null;
            kryo.writeClassAndObject(output, nullable);
        }

        @Override
        public Optional read(Kryo kryo, Input input, Class type) {
            return Optional.ofNullable(kryo.readClassAndObject(input));
        }

        @Override
        public Optional copy(Kryo kryo, Optional original) {
            if (original.isPresent()) {
                return Optional.of(kryo.copy(original.get()));
            }
            return original;
        }
    }
}

