/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.Image;
import com.google.cloud.vision.v1.ImageContext;
import com.google.cloud.vision.v1.ImageSource;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AnnotateImages;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
public class CloudVision {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_PARALLELISM = 5;

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromGcsUri annotateImagesFromGcsUri(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
        return new AnnotateImagesFromGcsUri(contextSideInput, features, batchSize, desiredRequestParallelism);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromGcsUri annotateImagesFromGcsUri(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize) {
        return CloudVision.annotateImagesFromGcsUri(contextSideInput, features, batchSize, 5);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromBytes annotateImagesFromBytes(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
        return new AnnotateImagesFromBytes(contextSideInput, features, batchSize, desiredRequestParallelism);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromBytes annotateImagesFromBytes(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize) {
        return CloudVision.annotateImagesFromBytes(contextSideInput, features, batchSize, 5);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromBytesWithContext annotateImagesFromBytesWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
        return new AnnotateImagesFromBytesWithContext(features, batchSize, desiredRequestParallelism);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromBytesWithContext annotateImagesFromBytesWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize) {
        return CloudVision.annotateImagesFromBytesWithContext(features, batchSize, 5);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromGcsUriWithContext annotateImagesFromGcsUriWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
        return new AnnotateImagesFromGcsUriWithContext(features, batchSize, desiredRequestParallelism);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateImagesFromGcsUriWithContext annotateImagesFromGcsUriWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> features, @UnknownKeyFor @NonNull @Initialized long batchSize) {
        return CloudVision.annotateImagesFromGcsUriWithContext(features, batchSize, 5);
    }

    public static class AnnotateImagesFromBytesWithContext
    extends AnnotateImages<KV<ByteString, ImageContext>> {
        public AnnotateImagesFromBytesWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
            super(featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AnnotateImageRequest mapToRequest(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ImageContext> input, @Nullable @UnknownKeyFor @Initialized ImageContext ctx) {
            Image image = Image.newBuilder().setContent((ByteString)input.getKey()).build();
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder().setImage(image).addAllFeatures((Iterable)this.featureList);
            if (input.getValue() != null) {
                builder.setImageContext((ImageContext)input.getValue());
            }
            return builder.build();
        }
    }

    public static class AnnotateImagesFromGcsUriWithContext
    extends AnnotateImages<KV<String, ImageContext>> {
        public AnnotateImagesFromGcsUriWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
            super(featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AnnotateImageRequest mapToRequest(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImageContext> input, @Nullable @UnknownKeyFor @Initialized ImageContext ctx) {
            ImageSource imageSource = ImageSource.newBuilder().setGcsImageUri((String)input.getKey()).build();
            Image image = Image.newBuilder().setSource(imageSource).build();
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder().setImage(image).addAllFeatures((Iterable)this.featureList);
            if (input.getValue() != null) {
                builder.setImageContext((ImageContext)input.getValue());
            }
            return builder.build();
        }
    }

    public static class AnnotateImagesFromBytes
    extends AnnotateImages<ByteString> {
        public AnnotateImagesFromBytes(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
            super(contextSideInput, featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AnnotateImageRequest mapToRequest(@UnknownKeyFor @NonNull @Initialized ByteString input, @Nullable @UnknownKeyFor @Initialized ImageContext ctx) {
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder();
            if (ctx != null) {
                builder.setImageContext(ctx);
            }
            return builder.addAllFeatures((Iterable)this.featureList).setImage(Image.newBuilder().setContent(input).build()).build();
        }
    }

    public static class AnnotateImagesFromGcsUri
    extends AnnotateImages<String> {
        public AnnotateImagesFromGcsUri(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImageContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList, @UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized int desiredRequestParallelism) {
            super(contextSideInput, featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AnnotateImageRequest mapToRequest(@UnknownKeyFor @NonNull @Initialized String uri, @Nullable @UnknownKeyFor @Initialized ImageContext ctx) {
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder();
            if (ctx != null) {
                builder.setImageContext(ctx);
            }
            ImageSource imgSource = ImageSource.newBuilder().setGcsImageUri(uri).build();
            return builder.addAllFeatures((Iterable)this.featureList).setImage(Image.newBuilder().setSource(imgSource).build()).build();
        }
    }
}

