/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.auto.value.AutoValue;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.privacy.dlp.v2.ContentItem;
import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.FieldId;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.ReidentifyContentRequest;
import com.google.privacy.dlp.v2.ReidentifyContentResponse;
import com.google.privacy.dlp.v2.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AutoValue_DLPReidentifyText;
import org.apache.beam.sdk.extensions.ml.BatchRequestForDLP;
import org.apache.beam.sdk.extensions.ml.MapStringToDlpRow;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
@AutoValue
public abstract class DLPReidentifyText
extends PTransform<PCollection<KV<String, String>>, PCollection<KV<String, ReidentifyContentResponse>>> {
    public static final @UnknownKeyFor @NonNull @Initialized Integer DLP_PAYLOAD_LIMIT_BYTES = 524000;

    public abstract @Nullable @UnknownKeyFor @Initialized String getInspectTemplateName();

    public abstract @Nullable @UnknownKeyFor @Initialized String getReidentifyTemplateName();

    public abstract @Nullable @UnknownKeyFor @Initialized InspectConfig getInspectConfig();

    public abstract @Nullable @UnknownKeyFor @Initialized DeidentifyConfig getReidentifyConfig();

    public abstract @Nullable @UnknownKeyFor @Initialized String getColumnDelimiter();

    public abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getHeaderColumns();

    public abstract @UnknownKeyFor @NonNull @Initialized Integer getBatchSizeBytes();

    public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_DLPReidentifyText.Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ReidentifyContentResponse>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> input) {
        ParDo.SingleOutput reidentifyParDo = ParDo.of((DoFn)new ReidentifyText(this.getProjectId(), this.getInspectTemplateName(), this.getReidentifyTemplateName(), this.getInspectConfig(), this.getReidentifyConfig(), this.getHeaderColumns()));
        if (this.getHeaderColumns() != null) {
            reidentifyParDo = reidentifyParDo.withSideInputs(new PCollectionView[]{this.getHeaderColumns()});
        }
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new MapStringToDlpRow(this.getColumnDelimiter())))).apply("Batch Contents", (PTransform)ParDo.of((DoFn)new BatchRequestForDLP(this.getBatchSizeBytes())))).apply("DLPReidentify", (PTransform)reidentifyParDo);
    }

    static class ReidentifyText
    extends DoFn<KV<String, Iterable<Table.Row>>, KV<String, ReidentifyContentResponse>> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String inspectTemplateName;
        private final @UnknownKeyFor @NonNull @Initialized String reidentifyTemplateName;
        private final @UnknownKeyFor @NonNull @Initialized InspectConfig inspectConfig;
        private final @UnknownKeyFor @NonNull @Initialized DeidentifyConfig reidentifyConfig;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> headerColumns;
        private transient // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ReidentifyContentRequest.Builder requestBuilder;
        private transient @UnknownKeyFor @NonNull @Initialized DlpServiceClient dlpServiceClient;

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.requestBuilder = ReidentifyContentRequest.newBuilder().setParent(ProjectName.of((String)this.projectId).toString());
            if (this.inspectTemplateName != null) {
                this.requestBuilder.setInspectTemplateName(this.inspectTemplateName);
            }
            if (this.inspectConfig != null) {
                this.requestBuilder.setInspectConfig(this.inspectConfig);
            }
            if (this.reidentifyConfig != null) {
                this.requestBuilder.setReidentifyConfig(this.reidentifyConfig);
            }
            if (this.reidentifyTemplateName != null) {
                this.requestBuilder.setReidentifyTemplateName(this.reidentifyTemplateName);
            }
            this.dlpServiceClient = DlpServiceClient.create();
        }

        @DoFn.Teardown
        public void teardown() {
            this.dlpServiceClient.close();
        }

        public ReidentifyText(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String inspectTemplateName, @UnknownKeyFor @NonNull @Initialized String reidentifyTemplateName, @UnknownKeyFor @NonNull @Initialized InspectConfig inspectConfig, @UnknownKeyFor @NonNull @Initialized DeidentifyConfig reidentifyConfig, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> headerColumns) {
            this.projectId = projectId;
            this.inspectTemplateName = inspectTemplateName;
            this.reidentifyTemplateName = reidentifyTemplateName;
            this.inspectConfig = inspectConfig;
            this.reidentifyConfig = reidentifyConfig;
            this.headerColumns = headerColumns;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            List<Object> tableHeaders;
            if (this.headerColumns != null) {
                tableHeaders = ((List)context.sideInput(this.headerColumns)).stream().map(header -> FieldId.newBuilder().setName(header).build()).collect(Collectors.toList());
            } else {
                tableHeaders = new ArrayList<FieldId>();
                tableHeaders.add(FieldId.newBuilder().setName("value").build());
            }
            Table table = Table.newBuilder().addAllHeaders(tableHeaders).addAllRows((Iterable)((KV)context.element()).getValue()).build();
            ContentItem contentItem = ContentItem.newBuilder().setTable(table).build();
            this.requestBuilder.setItem(contentItem);
            ReidentifyContentResponse response = this.dlpServiceClient.reidentifyContent(this.requestBuilder.build());
            context.output((Object)KV.of((Object)((String)((KV)context.element()).getKey()), (Object)response));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setInspectTemplateName(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setInspectConfig(@UnknownKeyFor @NonNull @Initialized InspectConfig var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setReidentifyConfig(@UnknownKeyFor @NonNull @Initialized DeidentifyConfig var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setReidentifyTemplateName(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setHeaderColumns(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setColumnDelimiter(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized DLPReidentifyText autoBuild();

        public @UnknownKeyFor @NonNull @Initialized DLPReidentifyText build() {
            DLPReidentifyText dlpReidentifyText = this.autoBuild();
            if (dlpReidentifyText.getReidentifyConfig() == null && dlpReidentifyText.getReidentifyTemplateName() == null) {
                throw new IllegalArgumentException("Either reidentifyConfig or reidentifyTemplateName need to be set!");
            }
            if (dlpReidentifyText.getBatchSizeBytes() > DLP_PAYLOAD_LIMIT_BYTES) {
                throw new IllegalArgumentException(String.format("Batch size is too large! It should be smaller or equal than %d.", DLP_PAYLOAD_LIMIT_BYTES));
            }
            if (dlpReidentifyText.getColumnDelimiter() == null && dlpReidentifyText.getHeaderColumns() != null) {
                throw new IllegalArgumentException("Column delimiter should be set if headers are present.");
            }
            if (dlpReidentifyText.getHeaderColumns() == null && dlpReidentifyText.getColumnDelimiter() != null) {
                throw new IllegalArgumentException("Column headers should be supplied when delimiter is present.");
            }
            return dlpReidentifyText;
        }
    }
}

