/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.videointelligence.v1.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import com.google.cloud.videointelligence.v1.VideoIntelligenceServiceClient;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

abstract class AnnotateVideoFn<@UnknownKeyFor T>
extends DoFn<T, List<VideoAnnotationResults>> {
    protected final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<T, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput;
    protected final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList;
    @UnknownKeyFor @NonNull @Initialized VideoIntelligenceServiceClient videoIntelligenceServiceClient;

    public AnnotateVideoFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<T, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
        this.contextSideInput = contextSideInput;
        this.featureList = featureList;
    }

    public AnnotateVideoFn(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
        this.contextSideInput = null;
        this.featureList = featureList;
    }

    @DoFn.Setup
    public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.videoIntelligenceServiceClient = VideoIntelligenceServiceClient.create();
    }

    @DoFn.Teardown
    public void teardown() {
        this.videoIntelligenceServiceClient.close();
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized VideoAnnotationResults> getVideoAnnotationResults(@UnknownKeyFor @NonNull @Initialized String elementURI, @UnknownKeyFor @NonNull @Initialized ByteString elementContents, @UnknownKeyFor @NonNull @Initialized VideoContext videoContext) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized ExecutionException {
        AnnotateVideoRequest.Builder requestBuilder = AnnotateVideoRequest.newBuilder().addAllFeatures(this.featureList);
        if (elementURI != null) {
            requestBuilder.setInputUri(elementURI);
        } else if (elementContents != null) {
            requestBuilder.setInputContent(elementContents);
        } else {
            throw new IllegalArgumentException("Either elementURI or elementContents should be non-null");
        }
        if (videoContext != null) {
            requestBuilder.setVideoContext(videoContext);
        }
        AnnotateVideoRequest annotateVideoRequest = requestBuilder.build();
        OperationFuture annotateVideoAsync = this.videoIntelligenceServiceClient.annotateVideoAsync(annotateVideoRequest);
        return ((AnnotateVideoResponse)annotateVideoAsync.get()).getAnnotationResultsList();
    }

    @DoFn.ProcessElement
    public abstract void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext var1) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException;
}

