/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogName;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceClient;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.ml.AutoValue_RecommendationAICreateCatalogItem;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.json.JSONObject;

@AutoValue
public abstract class RecommendationAICreateCatalogItem
extends PTransform<PCollection<GenericJson>, PCollectionTuple> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized CatalogItem> SUCCESS_TAG = new TupleTag<CatalogItem>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized CatalogItem> FAILURE_TAG = new TupleTag<CatalogItem>(){};

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String projectId();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String catalogName();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_RecommendationAICreateCatalogItem.Builder().setCatalogName("default_catalog");
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAICreateCatalogItem withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAICreateCatalogItem withCatalogName(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        return this.toBuilder().setCatalogName(catalogName).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GenericJson> input) {
        return (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new CreateCatalogItem(this.projectId(), this.catalogName())).withOutputTags(SUCCESS_TAG, TupleTagList.of(FAILURE_TAG)));
    }

    private static class CreateCatalogItem
    extends DoFn<GenericJson, CatalogItem> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String catalogName;

        private CreateCatalogItem(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String catalogName) {
            this.projectId = projectId;
            this.catalogName = catalogName;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            CatalogName parent = CatalogName.of((String)this.projectId, (String)"global", (String)this.catalogName);
            CatalogItem.Builder catalogItemBuilder = CatalogItem.newBuilder();
            JsonFormat.parser().merge(new JSONObject((Map)context.element()).toString(), (Message.Builder)catalogItemBuilder);
            CatalogItem catalogItem = catalogItemBuilder.build();
            try (CatalogServiceClient catalogServiceClient = CatalogServiceClient.create();){
                CatalogItem response = catalogServiceClient.createCatalogItem(parent, catalogItem);
                context.output(SUCCESS_TAG, (Object)response);
            }
            catch (ApiException e) {
                context.output(FAILURE_TAG, (Object)catalogItem);
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCatalogName(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized RecommendationAICreateCatalogItem build();
    }
}

