/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.recommendationengine.v1beta1.CatalogInlineSource;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogName;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceClient;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.InputConfig;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.extensions.ml.AutoValue_RecommendationAIImportCatalogItems;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.json.JSONObject;

@AutoValue
public abstract class RecommendationAIImportCatalogItems
extends PTransform<PCollection<KV<String, GenericJson>>, PCollectionTuple> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized CatalogItem> SUCCESS_TAG = new TupleTag<CatalogItem>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized CatalogItem> FAILURE_TAG = new TupleTag<CatalogItem>(){};

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_RecommendationAIImportCatalogItems.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public abstract @Nullable @UnknownKeyFor @Initialized String projectId();

    public abstract @Nullable @UnknownKeyFor @Initialized String catalogName();

    public abstract @UnknownKeyFor @NonNull @Initialized Integer batchSize();

    public abstract @UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration();

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportCatalogItems withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportCatalogItems withCatalogName(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        return this.toBuilder().setCatalogName(catalogName).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIImportCatalogItems withBatchSize(@UnknownKeyFor @NonNull @Initialized Integer batchSize) {
        return this.toBuilder().setBatchSize(batchSize).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized GenericJson>> input) {
        return (PCollectionTuple)((PCollection)input.apply("Batch Contents", (PTransform)GroupIntoBatches.ofSize((long)this.batchSize().intValue()).withMaxBufferingDuration(this.maxBufferingDuration()).withShardedKey())).apply("Import CatalogItems", (PTransform)ParDo.of((DoFn)new ImportCatalogItems(this.projectId(), this.catalogName())).withOutputTags(SUCCESS_TAG, TupleTagList.of(FAILURE_TAG)));
    }

    private static class ImportCatalogItems
    extends DoFn<KV<ShardedKey<String>, Iterable<GenericJson>>, CatalogItem> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String catalogName;

        private ImportCatalogItems(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String catalogName) {
            this.projectId = projectId;
            this.catalogName = catalogName;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            CatalogName parent = CatalogName.of((String)this.projectId, (String)"global", (String)this.catalogName);
            ArrayList<CatalogItem> catalogItems = new ArrayList<CatalogItem>();
            for (GenericJson element : (Iterable)((KV)c.element()).getValue()) {
                CatalogItem.Builder catalogItemBuilder = CatalogItem.newBuilder();
                JsonFormat.parser().merge(new JSONObject((Map)element).toString(), (Message.Builder)catalogItemBuilder);
                catalogItems.add(catalogItemBuilder.build());
            }
            CatalogInlineSource catalogInlineSource = CatalogInlineSource.newBuilder().addAllCatalogItems(catalogItems).build();
            InputConfig inputConfig = InputConfig.newBuilder().mergeCatalogInlineSource(catalogInlineSource).build();
            ImportCatalogItemsRequest request = ImportCatalogItemsRequest.newBuilder().setParent(parent.toString()).setInputConfig(inputConfig).build();
            try (CatalogServiceClient catalogServiceClient = CatalogServiceClient.create();){
                ImportCatalogItemsResponse response = (ImportCatalogItemsResponse)catalogServiceClient.importCatalogItemsAsync(request).get();
                if (response.getErrorSamplesCount() > 0) {
                    for (CatalogItem ci : catalogItems) {
                        c.output(FAILURE_TAG, (Object)ci);
                    }
                } else {
                    for (CatalogItem ci : catalogItems) {
                        c.output(SUCCESS_TAG, (Object)ci);
                    }
                }
            }
            catch (ApiException e) {
                for (CatalogItem ci : catalogItems) {
                    c.output(SUCCESS_TAG, (Object)ci);
                }
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCatalogName(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

        public abstract @UnknownKeyFor @NonNull @Initialized RecommendationAIImportCatalogItems build();
    }
}

