/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.recommendationengine.v1beta1.PlacementName;
import com.google.cloud.recommendationengine.v1beta1.PredictResponse;
import com.google.cloud.recommendationengine.v1beta1.PredictionServiceClient;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.ml.AutoValue_RecommendationAIPredict;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.json.JSONObject;

@AutoValue
public abstract class RecommendationAIPredict
extends PTransform<PCollection<GenericJson>, PCollectionTuple> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PredictResponse.PredictionResult> SUCCESS_TAG = new TupleTag<PredictResponse.PredictionResult>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized UserEvent> FAILURE_TAG = new TupleTag<UserEvent>(){};

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String projectId();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String catalogName();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String eventStore();

    public abstract @UnknownKeyFor @NonNull @Initialized String placementId();

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_RecommendationAIPredict.Builder().setCatalogName("default_catalog").setEventStore("default_event_store").setPlacementId("recently_viewed_default");
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIPredict withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIPredict withCatalogName(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        return this.toBuilder().setCatalogName(catalogName).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIPredict withEventStore(@UnknownKeyFor @NonNull @Initialized String eventStore) {
        return this.toBuilder().setEventStore(eventStore).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIPredict withPlacementId(@UnknownKeyFor @NonNull @Initialized String placementId) {
        return this.toBuilder().setPlacementId(placementId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GenericJson> input) {
        return (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new Predict(this.projectId(), this.catalogName(), this.eventStore(), this.placementId())).withOutputTags(SUCCESS_TAG, TupleTagList.of(FAILURE_TAG)));
    }

    private static class Predict
    extends DoFn<GenericJson, PredictResponse.PredictionResult> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String catalogName;
        private final @UnknownKeyFor @NonNull @Initialized String eventStore;
        private final @UnknownKeyFor @NonNull @Initialized String placementId;

        private Predict(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String catalogName, @UnknownKeyFor @NonNull @Initialized String eventStore, @UnknownKeyFor @NonNull @Initialized String placementId) {
            this.projectId = projectId;
            this.catalogName = catalogName;
            this.eventStore = eventStore;
            this.placementId = placementId;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            PlacementName name = PlacementName.of((String)this.projectId, (String)"global", (String)this.catalogName, (String)this.eventStore, (String)this.placementId);
            UserEvent.Builder userEventBuilder = UserEvent.newBuilder();
            JsonFormat.parser().merge(new JSONObject((Map)context.element()).toString(), (Message.Builder)userEventBuilder);
            UserEvent userEvent = userEventBuilder.build();
            try (PredictionServiceClient predictionServiceClient = PredictionServiceClient.create();){
                for (PredictResponse.PredictionResult res : predictionServiceClient.predict(name, userEvent).iterateAll()) {
                    context.output(SUCCESS_TAG, (Object)res);
                }
            }
            catch (ApiException e) {
                context.output(FAILURE_TAG, (Object)userEvent);
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCatalogName(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setEventStore(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setPlacementId(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized RecommendationAIPredict build();
    }
}

