/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.recommendationengine.v1beta1.EventStoreName;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.cloud.recommendationengine.v1beta1.UserEventServiceClient;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.ml.AutoValue_RecommendationAIWriteUserEvent;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.json.JSONObject;

@AutoValue
public abstract class RecommendationAIWriteUserEvent
extends PTransform<PCollection<GenericJson>, PCollectionTuple> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized UserEvent> SUCCESS_TAG = new TupleTag<UserEvent>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized UserEvent> FAILURE_TAG = new TupleTag<UserEvent>(){};

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_RecommendationAIWriteUserEvent.Builder().setCatalogName("default_catalog").setEventStore("default_event_store");
    }

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String projectId();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String catalogName();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String eventStore();

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GenericJson> input) {
        return (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new WriteUserEvent(this.projectId(), this.catalogName(), this.eventStore())).withOutputTags(SUCCESS_TAG, TupleTagList.of(FAILURE_TAG)));
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIWriteUserEvent withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIWriteUserEvent withCatalogName(@UnknownKeyFor @NonNull @Initialized String catalogName) {
        return this.toBuilder().setCatalogName(catalogName).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RecommendationAIWriteUserEvent withEventStore(@UnknownKeyFor @NonNull @Initialized String eventStore) {
        return this.toBuilder().setEventStore(eventStore).build();
    }

    private static class WriteUserEvent
    extends DoFn<GenericJson, UserEvent> {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String catalogName;
        private final @UnknownKeyFor @NonNull @Initialized String eventStore;

        private WriteUserEvent(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String catalogName, @UnknownKeyFor @NonNull @Initialized String eventStore) {
            this.projectId = projectId;
            this.catalogName = catalogName;
            this.eventStore = eventStore;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            EventStoreName parent = EventStoreName.of((String)this.projectId, (String)"global", (String)this.catalogName, (String)this.eventStore);
            UserEvent.Builder userEventBuilder = UserEvent.newBuilder();
            JsonFormat.parser().merge(new JSONObject((Map)context.element()).toString(), (Message.Builder)userEventBuilder);
            UserEvent userEvent = userEventBuilder.build();
            try (UserEventServiceClient userEventServiceClient = UserEventServiceClient.create();){
                UserEvent response = userEventServiceClient.writeUserEvent(parent, userEvent);
                context.output(SUCCESS_TAG, (Object)response);
            }
            catch (ApiException e) {
                context.output(FAILURE_TAG, (Object)userEvent);
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCatalogName(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setEventStore(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized RecommendationAIWriteUserEvent build();
    }
}

