/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoBytesWithContextFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFromBytesFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFromURIFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoURIWithContextFn;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VideoIntelligence {
    public static @UnknownKeyFor @NonNull @Initialized AnnotateVideoFromUri annotateFromURI(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput) {
        return new AnnotateVideoFromUri(contextSideInput, featureList);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateVideoFromBytes annotateFromBytes(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
        return new AnnotateVideoFromBytes(contextSideInput, featureList);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateVideoFromURIWithContext annotateFromUriWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
        return new AnnotateVideoFromURIWithContext(featureList);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotateVideoFromBytesWithContext annotateFromBytesWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
        return new AnnotateVideoFromBytesWithContext(featureList);
    }

    public static class AnnotateVideoFromBytesWithContext
    extends PTransform<PCollection<KV<ByteString, VideoContext>>, PCollection<List<VideoAnnotationResults>>> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList;

        protected AnnotateVideoFromBytesWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
            this.featureList = featureList;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized VideoAnnotationResults>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized VideoContext>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoBytesWithContextFn(this.featureList)));
        }
    }

    public static class AnnotateVideoFromURIWithContext
    extends PTransform<PCollection<KV<String, VideoContext>>, PCollection<List<VideoAnnotationResults>>> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList;

        protected AnnotateVideoFromURIWithContext(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
            this.featureList = featureList;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized VideoAnnotationResults>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized VideoContext>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoURIWithContextFn(this.featureList)));
        }
    }

    public static class AnnotateVideoFromBytes
    extends PTransform<PCollection<ByteString>, PCollection<List<VideoAnnotationResults>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList;

        protected AnnotateVideoFromBytes(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
            this.contextSideInput = contextSideInput;
            this.featureList = featureList;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized VideoAnnotationResults>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ByteString> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoFromBytesFn(this.contextSideInput, this.featureList)));
        }
    }

    public static class AnnotateVideoFromUri
    extends PTransform<PCollection<String>, PCollection<List<VideoAnnotationResults>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList;

        protected AnnotateVideoFromUri(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized VideoContext>> contextSideInput, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Feature> featureList) {
            this.contextSideInput = contextSideInput;
            this.featureList = featureList;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized VideoAnnotationResults>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoFromURIFn(this.contextSideInput, this.featureList)));
        }
    }
}

