/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.InspectConfig;
import java.util.List;
import org.apache.beam.sdk.extensions.ml.DLPReidentifyText;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_DLPReidentifyText
extends DLPReidentifyText {
    private final @Nullable String inspectTemplateName;
    private final @Nullable String reidentifyTemplateName;
    private final @Nullable InspectConfig inspectConfig;
    private final @Nullable DeidentifyConfig reidentifyConfig;
    private final @Nullable String columnDelimiter;
    private final @Nullable PCollectionView<List<String>> headerColumns;
    private final Integer batchSizeBytes;
    private final String projectId;

    private AutoValue_DLPReidentifyText(@Nullable String inspectTemplateName, @Nullable String reidentifyTemplateName, @Nullable InspectConfig inspectConfig, @Nullable DeidentifyConfig reidentifyConfig, @Nullable String columnDelimiter, @Nullable PCollectionView<List<String>> headerColumns, Integer batchSizeBytes, String projectId) {
        this.inspectTemplateName = inspectTemplateName;
        this.reidentifyTemplateName = reidentifyTemplateName;
        this.inspectConfig = inspectConfig;
        this.reidentifyConfig = reidentifyConfig;
        this.columnDelimiter = columnDelimiter;
        this.headerColumns = headerColumns;
        this.batchSizeBytes = batchSizeBytes;
        this.projectId = projectId;
    }

    @Override
    public @Nullable String getInspectTemplateName() {
        return this.inspectTemplateName;
    }

    @Override
    public @Nullable String getReidentifyTemplateName() {
        return this.reidentifyTemplateName;
    }

    @Override
    public @Nullable InspectConfig getInspectConfig() {
        return this.inspectConfig;
    }

    @Override
    public @Nullable DeidentifyConfig getReidentifyConfig() {
        return this.reidentifyConfig;
    }

    @Override
    public @Nullable String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    @Override
    public @Nullable PCollectionView<List<String>> getHeaderColumns() {
        return this.headerColumns;
    }

    @Override
    public Integer getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DLPReidentifyText) {
            DLPReidentifyText that = (DLPReidentifyText)((Object)o);
            return (this.inspectTemplateName == null ? that.getInspectTemplateName() == null : this.inspectTemplateName.equals(that.getInspectTemplateName())) && (this.reidentifyTemplateName == null ? that.getReidentifyTemplateName() == null : this.reidentifyTemplateName.equals(that.getReidentifyTemplateName())) && (this.inspectConfig == null ? that.getInspectConfig() == null : this.inspectConfig.equals((Object)that.getInspectConfig())) && (this.reidentifyConfig == null ? that.getReidentifyConfig() == null : this.reidentifyConfig.equals((Object)that.getReidentifyConfig())) && (this.columnDelimiter == null ? that.getColumnDelimiter() == null : this.columnDelimiter.equals(that.getColumnDelimiter())) && (this.headerColumns == null ? that.getHeaderColumns() == null : this.headerColumns.equals(that.getHeaderColumns())) && this.batchSizeBytes.equals(that.getBatchSizeBytes()) && this.projectId.equals(that.getProjectId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.inspectTemplateName == null ? 0 : this.inspectTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.reidentifyTemplateName == null ? 0 : this.reidentifyTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.inspectConfig == null ? 0 : this.inspectConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.reidentifyConfig == null ? 0 : this.reidentifyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.columnDelimiter == null ? 0 : this.columnDelimiter.hashCode();
        h$ *= 1000003;
        h$ ^= this.headerColumns == null ? 0 : this.headerColumns.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSizeBytes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.projectId.hashCode();
    }

    static final class Builder
    extends DLPReidentifyText.Builder {
        private @Nullable String inspectTemplateName;
        private @Nullable String reidentifyTemplateName;
        private @Nullable InspectConfig inspectConfig;
        private @Nullable DeidentifyConfig reidentifyConfig;
        private @Nullable String columnDelimiter;
        private @Nullable PCollectionView<List<String>> headerColumns;
        private Integer batchSizeBytes;
        private String projectId;

        Builder() {
        }

        @Override
        public DLPReidentifyText.Builder setInspectTemplateName(String inspectTemplateName) {
            this.inspectTemplateName = inspectTemplateName;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setReidentifyTemplateName(String reidentifyTemplateName) {
            this.reidentifyTemplateName = reidentifyTemplateName;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setInspectConfig(InspectConfig inspectConfig) {
            this.inspectConfig = inspectConfig;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setReidentifyConfig(DeidentifyConfig reidentifyConfig) {
            this.reidentifyConfig = reidentifyConfig;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setColumnDelimiter(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setHeaderColumns(PCollectionView<List<String>> headerColumns) {
            this.headerColumns = headerColumns;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setBatchSizeBytes(Integer batchSizeBytes) {
            if (batchSizeBytes == null) {
                throw new NullPointerException("Null batchSizeBytes");
            }
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        public DLPReidentifyText.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        DLPReidentifyText autoBuild() {
            if (this.batchSizeBytes == null || this.projectId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.batchSizeBytes == null) {
                    missing.append(" batchSizeBytes");
                }
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DLPReidentifyText(this.inspectTemplateName, this.reidentifyTemplateName, this.inspectConfig, this.reidentifyConfig, this.columnDelimiter, this.headerColumns, this.batchSizeBytes, this.projectId);
        }
    }
}

