/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import org.apache.beam.sdk.extensions.ml.RecommendationAIImportCatalogItems;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_RecommendationAIImportCatalogItems
extends RecommendationAIImportCatalogItems {
    private final @Nullable String projectId;
    private final @Nullable String catalogName;
    private final Integer batchSize;
    private final Duration maxBufferingDuration;

    private AutoValue_RecommendationAIImportCatalogItems(@Nullable String projectId, @Nullable String catalogName, Integer batchSize, Duration maxBufferingDuration) {
        this.projectId = projectId;
        this.catalogName = catalogName;
        this.batchSize = batchSize;
        this.maxBufferingDuration = maxBufferingDuration;
    }

    @Override
    public @Nullable String projectId() {
        return this.projectId;
    }

    @Override
    public @Nullable String catalogName() {
        return this.catalogName;
    }

    @Override
    public Integer batchSize() {
        return this.batchSize;
    }

    @Override
    public Duration maxBufferingDuration() {
        return this.maxBufferingDuration;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RecommendationAIImportCatalogItems) {
            RecommendationAIImportCatalogItems that = (RecommendationAIImportCatalogItems)((Object)o);
            return (this.projectId == null ? that.projectId() == null : this.projectId.equals(that.projectId())) && (this.catalogName == null ? that.catalogName() == null : this.catalogName.equals(that.catalogName())) && this.batchSize.equals(that.batchSize()) && this.maxBufferingDuration.equals((Object)that.maxBufferingDuration());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.catalogName == null ? 0 : this.catalogName.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSize.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxBufferingDuration.hashCode();
    }

    @Override
    RecommendationAIImportCatalogItems.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RecommendationAIImportCatalogItems.Builder {
        private @Nullable String projectId;
        private @Nullable String catalogName;
        private Integer batchSize;
        private Duration maxBufferingDuration;

        Builder() {
        }

        private Builder(RecommendationAIImportCatalogItems source) {
            this.projectId = source.projectId();
            this.catalogName = source.catalogName();
            this.batchSize = source.batchSize();
            this.maxBufferingDuration = source.maxBufferingDuration();
        }

        @Override
        public RecommendationAIImportCatalogItems.Builder setProjectId(@Nullable String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public RecommendationAIImportCatalogItems.Builder setCatalogName(@Nullable String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        @Override
        public RecommendationAIImportCatalogItems.Builder setBatchSize(Integer batchSize) {
            if (batchSize == null) {
                throw new NullPointerException("Null batchSize");
            }
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public RecommendationAIImportCatalogItems.Builder setMaxBufferingDuration(Duration maxBufferingDuration) {
            if (maxBufferingDuration == null) {
                throw new NullPointerException("Null maxBufferingDuration");
            }
            this.maxBufferingDuration = maxBufferingDuration;
            return this;
        }

        @Override
        public RecommendationAIImportCatalogItems build() {
            if (this.batchSize == null || this.maxBufferingDuration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.batchSize == null) {
                    missing.append(" batchSize");
                }
                if (this.maxBufferingDuration == null) {
                    missing.append(" maxBufferingDuration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RecommendationAIImportCatalogItems(this.projectId, this.catalogName, this.batchSize, this.maxBufferingDuration);
        }
    }
}

