/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.Table;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchRequestForDLP
extends DoFn<KV<String, Table.Row>, KV<String, Iterable<Table.Row>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BatchRequestForDLP.class);
    private final @UnknownKeyFor @NonNull @Initialized Counter numberOfRowsBagged = Metrics.counter(BatchRequestForDLP.class, (String)"numberOfRowsBagged");
    private final @UnknownKeyFor @NonNull @Initialized Integer batchSizeBytes;
    @DoFn.StateId(value="elementsBag")
    private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Table.Row>>> elementsBag = StateSpecs.bag();
    @DoFn.TimerId(value="eventTimer")
    private final @UnknownKeyFor @NonNull @Initialized TimerSpec eventTimer = TimerSpecs.timer((TimeDomain)TimeDomain.EVENT_TIME);

    public BatchRequestForDLP(@UnknownKeyFor @NonNull @Initialized Integer batchSize) {
        this.batchSizeBytes = batchSize;
    }

    @DoFn.ProcessElement
    public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Table.Row> element, @DoFn.StateId(value="elementsBag") @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Table.Row>> elementsBag, @DoFn.TimerId(value="eventTimer") @UnknownKeyFor @NonNull @Initialized Timer eventTimer, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
        elementsBag.add(element);
        eventTimer.set(w.maxTimestamp());
    }

    @DoFn.OnTimer(value="eventTimer")
    public void onTimer(@DoFn.StateId(value="elementsBag") @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Table.Row>> elementsBag, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Table.Row>>> output) {
        if (elementsBag.read().iterator().hasNext()) {
            String key = (String)((KV)elementsBag.read().iterator().next()).getKey();
            AtomicInteger bufferSize = new AtomicInteger();
            ArrayList rows = new ArrayList();
            elementsBag.read().forEach(element -> {
                boolean clearBuffer;
                int elementSize = ((Table.Row)element.getValue()).getSerializedSize();
                boolean bl = clearBuffer = bufferSize.intValue() + elementSize > this.batchSizeBytes;
                if (clearBuffer) {
                    LOG.debug("Clear buffer of {} bytes, Key {}", (Object)bufferSize.intValue(), element.getKey());
                    this.numberOfRowsBagged.inc((long)rows.size());
                    output.output((Object)KV.of((Object)((String)element.getKey()), (Object)rows));
                    rows.clear();
                    bufferSize.set(0);
                }
                rows.add((Table.Row)element.getValue());
                bufferSize.getAndAdd(((Table.Row)element.getValue()).getSerializedSize());
            });
            if (!rows.isEmpty()) {
                LOG.debug("Outputting remaining {} rows.", (Object)rows.size());
                this.numberOfRowsBagged.inc((long)rows.size());
                output.output((Object)KV.of((Object)key, rows));
            }
        }
    }
}

